//************************************************************************************
//**  
//**  File name:     C:\Documents and Settings\FARSHAD\Desktop\flowcode\eca.c
//**  Generated by:  Flowcode v4.3.6.61
//**  Date:          Thursday, December 23, 2010 01:21:35
//**  Licence:       Professional
//**  Registered to: 20ACM8
//**  
//**  
//**  http://www.matrixmultimedia.com
//************************************************************************************


#define MX_AVR

//Defines for microcontroller
#define MX_AVR
#define MX_EE
#define MX_EE_SIZE 1024
#define MX_SPI
#define MX_SPI_B
#define MX_SPI_SDI 6
#define MX_SPI_SDO 5
#define MX_SPI_SCK 7
#define MX_UART
#define MX_UART_D
#define MX_UART_TX 1
#define MX_UART_RX 0
#define MX_MI2C
#define MX_I2C_C
#define MX_I2C_SDA 1
#define MX_I2C_SCL 0
#define MX_PWM
#define MX_PWM_PORT PORTD
#define MX_PWM_CNT 2
#define MX_PWM_TRIS1 DDRD
#define MX_PWM_1 5
#define MX_PWM_TRIS2 DDRD
#define MX_PWM_2 4
#define MX_PWMTYPE 1

//Functions
#define F_CPU 20000000UL
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <avr\io.h>
#include <avr\interrupt.h>
#include <avr\eeprom.h>
#include <avr\wdt.h>
#include <MX_util\delay.h>
#include <MX_util\bit_cmds.h>

//Configuration data
#pragma DATA 0x0, 0xdf
#pragma DATA 0x1, 0xff

//Internal functions
#include "D:\Program Files\Matrix Multimedia\Flowcode AVR V4\FCD\internals.h"

//Macro function declarations
void FCM_right();
void FCM_left();


//Variable declarations
#define FCSZ_RIGHT_LCD 20
#define FCSZ_LEFT_LCD 20
volatile char FCV_RIGHT_LCD[FCSZ_RIGHT_LCD];
volatile char FCV_RIGHT;
volatile char FCV_LEFT;
volatile char FCV_LEFT_LCD[FCSZ_LEFT_LCD];


//Defines:

/**** Macro Substitutions ****
PORTB = D1 Port
DDRB = D1 Data Direction
PORTB = D2 Port
DDRB = D2 Data Direction
PORTB = D3 Port
DDRB = D3 Data Direction
PORTB = D4 Port
DDRB = D4 Data Direction
PORTB = RS Port
DDRB = RS Data Direction
PORTB = E Port
DDRB = E Data Direction
0 = Data 1_Pin
1 = Data 2 Pin
2 = Data 3 Pin
3 = Data 4 Pin
4 = RS Pin
5 = Enable Pin
LCD_656564 = Unique Component Reference Number
2 = Row Count
16 = Column Count
******************************/

	//component connections
	#define LCD_656564_PORT0    PORTB
	#define LCD_656564_DDR0    DDRB
	#define LCD_656564_PORT1    PORTB
	#define LCD_656564_DDR1    DDRB
	#define LCD_656564_PORT2    PORTB
	#define LCD_656564_DDR2    DDRB
	#define LCD_656564_PORT3    PORTB
	#define LCD_656564_DDR3    DDRB
	#define LCD_656564_PORT4    PORTB
	#define LCD_656564_DDR4    DDRB
	#define LCD_656564_PORT5    PORTB
	#define LCD_656564_DDR5    DDRB
	#define LCD_656564_BIT0    	0
	#define LCD_656564_BIT1    	1
	#define LCD_656564_BIT2    	2
	#define LCD_656564_BIT3    	3
	#define LCD_656564_RS      	4
	#define LCD_656564_E       	5
	#define LCD_656564_ROWCNT	2
	#define LCD_656564_COLCNT	16

    #define LCD_656564_DELAY   delay_us(100)




//LCDDisplay(0): //Macro function declarations

static void FCD_LCDDisplay0_RawSend(char in, char mask);
static void FCD_LCDDisplay0_Start();
static void FCD_LCDDisplay0_Clear();
static void FCD_LCDDisplay0_PrintASCII(char Character);
static void FCD_LCDDisplay0_Command(char in);
static void FCD_LCDDisplay0_Cursor(char x, char y);
static void FCD_LCDDisplay0_PrintNumber(short Number);
static void FCD_LCDDisplay0_PrintString(char* String, char MSZ_String);
static void FCD_LCDDisplay0_ScrollDisplay(char Direction, char Num_Positions);
static void FCD_LCDDisplay0_ClearLine(char Line);
static void FCD_LCDDisplay0_RAM_Write(char nIdx, char d0, char d1, char d2, char d3, char d4, char d5, char d6, char d7);
//Defines:

/**** Macro Substitutions ****
PORTA = Coil 1 Port Register
DDRA = Coil 1 Data Direction Register
0 = Coil 1 Pin
PORTA = Coil 2 Port Register
DDRA = Coil 2 Data Direction Register
1 = Coil 2 Pin
PORTA = Coil 3 Port Register
DDRA = Coil 3 Data Direction Register
2 = Coil 3 Pin
PORTA = Coil 4 Port Register
DDRA = Coil 4 Data Direction Register
3 = Coil 4 Pin
0 = Step Type - 0 = half step, 1 = full step (2-2), 2 = wave (1-1)
0 = Motor Type - 0 = bipolar/unipolar +ve, 1 = unipolar -ve
0 = Number of Full Steps Per Revolution
0 = Unused
Stepper_1574098 = Unique Component Identifier
******************************/

//common defines
#define MX_Stepper_1574098_PORT1			PORTA	//0
#define MX_Stepper_1574098_DDR1			DDRA
#define MX_Stepper_1574098_PIN1			0
#define MX_Stepper_1574098_PORT2			PORTA	//1
#define MX_Stepper_1574098_DDR2			DDRA
#define MX_Stepper_1574098_PIN2			1
#define MX_Stepper_1574098_PORT3			PORTA	//2
#define MX_Stepper_1574098_DDR3			DDRA
#define MX_Stepper_1574098_PIN3			2
#define MX_Stepper_1574098_PORT4			PORTA	//3
#define MX_Stepper_1574098_DDR4			DDRA
#define MX_Stepper_1574098_PIN4			3
#define MX_Stepper_1574098_STEP_TYPE		0	//0 = half step, 1 = full step (2-2), 2 = wave (1-1)
#define MX_Stepper_1574098_WINDING_TYPE	0	//0 = bipolar/unipolar +ve, 1 = unipolar -ve


#if (MX_Stepper_1574098_WINDING_TYPE == 2)
	char Stepper_1574098_pattern[8] = {0x06, 0x0e, 0x0a, 0x0b, 0x09, 0x0d, 0x05, 0x07};
#else
	char Stepper_1574098_pattern[8] = {0x09, 0x01, 0x05, 0x04, 0x06, 0x02, 0x0a, 0x08};
#endif


#if (MX_Stepper_1574098_STEP_TYPE == 0)
	#define MX_Stepper_1574098_INC_STEP	1
#else
	#define MX_Stepper_1574098_INC_STEP	2
#endif

char Stepper_1574098_phase = 0;
char Stepper_1574098_enabled = 0;




//Stepper(0): //Macro function declarations

static void FCD_Stepper0_IncrementStep();
static void FCD_Stepper0_DecrementStep();
static void FCD_Stepper0_EnableMotor();
static void FCD_Stepper0_DisableMotor();



//LCDDisplay(0): //Macro implementations


static void FCD_LCDDisplay0_RawSend(char in, char mask)
{
		unsigned char pt;

		clear_bit(LCD_656564_PORT0, LCD_656564_BIT0);
		clear_bit(LCD_656564_PORT1, LCD_656564_BIT1);
		clear_bit(LCD_656564_PORT2, LCD_656564_BIT2);
		clear_bit(LCD_656564_PORT3, LCD_656564_BIT3);
		clear_bit(LCD_656564_PORT4, LCD_656564_RS);
		clear_bit(LCD_656564_PORT5, LCD_656564_E);
		pt = ((in >> 4) & 0x0f);
		if (pt & 0x01)
		    set_bit(LCD_656564_PORT0, LCD_656564_BIT0);
		if (pt & 0x02)
		    set_bit(LCD_656564_PORT1, LCD_656564_BIT1);
		if (pt & 0x04)
		    set_bit(LCD_656564_PORT2, LCD_656564_BIT2);
		if (pt & 0x08)
		    set_bit(LCD_656564_PORT3, LCD_656564_BIT3);
		if (mask)
		    set_bit(LCD_656564_PORT4, LCD_656564_RS);
		LCD_656564_DELAY;
		set_bit (LCD_656564_PORT5, LCD_656564_E);
		LCD_656564_DELAY;
		clear_bit (LCD_656564_PORT5, LCD_656564_E);
		pt = (in & 0x0f);
		LCD_656564_DELAY;
		clear_bit(LCD_656564_PORT0, LCD_656564_BIT0);
		clear_bit(LCD_656564_PORT1, LCD_656564_BIT1);
		clear_bit(LCD_656564_PORT2, LCD_656564_BIT2);
		clear_bit(LCD_656564_PORT3, LCD_656564_BIT3);
		clear_bit(LCD_656564_PORT4, LCD_656564_RS);
		clear_bit(LCD_656564_PORT5, LCD_656564_E);
		if (pt & 0x01)
		    set_bit(LCD_656564_PORT0, LCD_656564_BIT0);
		if (pt & 0x02)
		    set_bit(LCD_656564_PORT1, LCD_656564_BIT1);
		if (pt & 0x04)
		    set_bit(LCD_656564_PORT2, LCD_656564_BIT2);
		if (pt & 0x08)
		    set_bit(LCD_656564_PORT3, LCD_656564_BIT3);
		if (mask)
		    set_bit(LCD_656564_PORT4, LCD_656564_RS);
		LCD_656564_DELAY;
		set_bit (LCD_656564_PORT5, LCD_656564_E);
		LCD_656564_DELAY;
		clear_bit (LCD_656564_PORT5, LCD_656564_E);
		LCD_656564_DELAY;
}

static void FCD_LCDDisplay0_Start()
{
	
		set_bit(LCD_656564_DDR0, LCD_656564_BIT0);
		set_bit(LCD_656564_DDR1, LCD_656564_BIT1);
		set_bit(LCD_656564_DDR2, LCD_656564_BIT2);
		set_bit(LCD_656564_DDR3, LCD_656564_BIT3);
		set_bit(LCD_656564_DDR4, LCD_656564_RS);
		set_bit(LCD_656564_DDR5, LCD_656564_E);

		Wdt_Delay_Ms(12);

		FCD_LCDDisplay0_RawSend(0x33, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x33, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x32, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x2c, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x06, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x0c, 0);
		Wdt_Delay_Ms(2);

		//clear the display
		FCD_LCDDisplay0_RawSend(0x01, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x02, 0);
		Wdt_Delay_Ms(2);

}

static void FCD_LCDDisplay0_Clear()
{
	
		FCD_LCDDisplay0_RawSend(0x01, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x02, 0);
		Wdt_Delay_Ms(2);

}

static void FCD_LCDDisplay0_PrintASCII(char Character)
{
	
		FCD_LCDDisplay0_RawSend(Character, 0x10);

}

static void FCD_LCDDisplay0_Command(char in)
{
	
		FCD_LCDDisplay0_RawSend(in, 0);
		Wdt_Delay_Ms(2);

}

static void FCD_LCDDisplay0_Cursor(char x, char y)
{
	
	  #if (LCD_656564_ROWCNT == 1)
	    y=0x80;
	  #endif

	  #if (LCD_656564_ROWCNT == 2)
		if (y==0)
			y=0x80;
		else
			y=0xc0;
	  #endif

	  #if (LCD_656564_ROWCNT == 4)
		if (y==0)
			y=0x80;
		else if (y==1)
			y=0xc0;

		#if (LCD_656564_COLCNT == 16)
			else if (y==2)
				y=0x90;
			else
				y=0xd0;
		#endif

		#if (LCD_656564_COLCNT == 20)
			else if (y==2)
				y=0x94;
			else
				y=0xd4;
		#endif
	  #endif

		FCD_LCDDisplay0_RawSend(y+x, 0);
		Wdt_Delay_Ms(2);

}

static void FCD_LCDDisplay0_PrintNumber(short Number)
{
	
		short tmp_int;
		char tmp_byte;
		if (Number < 0)
		{
			FCD_LCDDisplay0_RawSend('-', 0x10);
			Number = 0 - Number;
		}

		tmp_int = Number;
		if (Number >= 10000)
		{
			tmp_byte = tmp_int / 10000;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 10000;
				tmp_byte--;
			}
		}
		if (Number >= 1000)
		{
			tmp_byte = tmp_int / 1000;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 1000;
				tmp_byte--;
			}
		}
		if (Number >= 100)
		{
			tmp_byte = tmp_int / 100;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 100;
				tmp_byte--;
			}
		}
		if (Number >= 10)
		{
			tmp_byte = tmp_int / 10;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 10;
				tmp_byte--;
			}
		}
		FCD_LCDDisplay0_RawSend('0' + tmp_int, 0x10);

}

static void FCD_LCDDisplay0_PrintString(char* String, char MSZ_String)
{
	
		char idx;
		for (idx=0; idx<MSZ_String; idx++)
		{
			if (String[idx]==0)
			{
				break;
			}
			FCD_LCDDisplay0_RawSend(String[idx], 0x10);
		}

}

static void FCD_LCDDisplay0_ScrollDisplay(char Direction, char Num_Positions)
{
	
		char cmd = 0;
		char count;

		//Choose the direction
		switch (Direction)
		{
			case 0:
			case 'l':
			case 'L':

				cmd = 0x18;
				break;

			case 1:
			case 'r':
			case 'R':

				cmd = 0x1C;
				break;

			default:
				break;
		}

		//If direction accepted then scroll the specified amount
		if (cmd)
		{
			for (count = 0; count < Num_Positions; count++)
				FCD_LCDDisplay0_Command(cmd);
		}

}

static void FCD_LCDDisplay0_ClearLine(char Line)
{
	
		char count;
		char rowcount;

		//Define number of columns per line
		#if (LCD_656564_ROWCNT == 1)
			rowcount=80;
		#endif

		#if (LCD_656564_ROWCNT == 2)
			rowcount=40;
		#endif

		#if (LCD_656564_ROWCNT == 4)
			#if (LCD_656564_COLCNT == 16)
				rowcount=16;
			#endif
			#if (LCD_656564_COLCNT == 20)
				rowcount=20;
			#endif
		#endif

		//Start at beginning of the line
		FCD_LCDDisplay0_Cursor (0, Line);

		//Send out spaces to clear line
		for (count = 0; count < rowcount; count++)
			FCD_LCDDisplay0_RawSend(' ', 0x10);

		//Move back to the beginning of the line.
		FCD_LCDDisplay0_Cursor (0, Line);

}

static void FCD_LCDDisplay0_RAM_Write(char nIdx, char d0, char d1, char d2, char d3, char d4, char d5, char d6, char d7)
{
	   //set CGRAM address
	   FCD_LCDDisplay0_RawSend(64 + (nIdx << 3), 0);
	   delay_ms(2);

	   //write CGRAM data
	   FCD_LCDDisplay0_RawSend(d0, 0x10);
	   FCD_LCDDisplay0_RawSend(d1, 0x10);
	   FCD_LCDDisplay0_RawSend(d2, 0x10);
	   FCD_LCDDisplay0_RawSend(d3, 0x10);
	   FCD_LCDDisplay0_RawSend(d4, 0x10);
	   FCD_LCDDisplay0_RawSend(d5, 0x10);
	   FCD_LCDDisplay0_RawSend(d6, 0x10);
	   FCD_LCDDisplay0_RawSend(d7, 0x10);

	   //Clear the display
	   FCD_LCDDisplay0_RawSend(0x01, 0);
	   delay_ms(2);
	   FCD_LCDDisplay0_RawSend(0x02, 0);
	   delay_ms(2);
}



//Stepper(0): //Macro implementations


static void FCD_Stepper0_IncrementStep()
{
		char pattern_now;

		if( Stepper_1574098_enabled)
		{
			Stepper_1574098_phase = (Stepper_1574098_phase + MX_Stepper_1574098_INC_STEP);	//increment step

			#if (MX_Stepper_1574098_STEP_TYPE == 1)
				Stepper_1574098_phase &=0x06;		//full step, even index
			#endif

			#if (MX_Stepper_1574098_STEP_TYPE == 2)								//full step, odd index
				Stepper_1574098_phase |=0x01;
			#endif

			Stepper_1574098_phase &= 0x07;
			pattern_now = Stepper_1574098_pattern[Stepper_1574098_phase];

			if(test_bit(pattern_now, 0)) set_bit (MX_Stepper_1574098_PORT1, MX_Stepper_1574098_PIN1);
			else clear_bit (MX_Stepper_1574098_PORT1, MX_Stepper_1574098_PIN1);
			if(test_bit(pattern_now, 1)) set_bit (MX_Stepper_1574098_PORT2, MX_Stepper_1574098_PIN2);
			else clear_bit (MX_Stepper_1574098_PORT2, MX_Stepper_1574098_PIN2);
			if(test_bit(pattern_now, 2)) set_bit (MX_Stepper_1574098_PORT3, MX_Stepper_1574098_PIN3);
			else clear_bit (MX_Stepper_1574098_PORT3, MX_Stepper_1574098_PIN3);
			if(test_bit(pattern_now, 3)) set_bit (MX_Stepper_1574098_PORT4, MX_Stepper_1574098_PIN4);
			else clear_bit (MX_Stepper_1574098_PORT4, MX_Stepper_1574098_PIN4);
		}
}

static void FCD_Stepper0_DecrementStep()
{
		char pattern_now;

		if( Stepper_1574098_enabled)
		{

			Stepper_1574098_phase = (Stepper_1574098_phase - MX_Stepper_1574098_INC_STEP);	//increment step

			#if (MX_Stepper_1574098_STEP_TYPE == 1)
				Stepper_1574098_phase &=0x06;		//full step, even index
			#endif

			#if (MX_Stepper_1574098_STEP_TYPE == 2)			//full step, odd index
				Stepper_1574098_phase |=0x01;
			#endif

			Stepper_1574098_phase &= 0x07;
			pattern_now = Stepper_1574098_pattern[Stepper_1574098_phase];

			if(test_bit(pattern_now, 0)) set_bit (MX_Stepper_1574098_PORT1, MX_Stepper_1574098_PIN1);
			else clear_bit (MX_Stepper_1574098_PORT1, MX_Stepper_1574098_PIN1);
			if(test_bit(pattern_now, 1)) set_bit (MX_Stepper_1574098_PORT2, MX_Stepper_1574098_PIN2);
			else clear_bit (MX_Stepper_1574098_PORT2, MX_Stepper_1574098_PIN2);
			if(test_bit(pattern_now, 2)) set_bit (MX_Stepper_1574098_PORT3, MX_Stepper_1574098_PIN3);
			else clear_bit (MX_Stepper_1574098_PORT3, MX_Stepper_1574098_PIN3);
			if(test_bit(pattern_now, 3)) set_bit (MX_Stepper_1574098_PORT4, MX_Stepper_1574098_PIN4);
			else clear_bit (MX_Stepper_1574098_PORT4, MX_Stepper_1574098_PIN4);
		}
}

static void FCD_Stepper0_EnableMotor()
{
		Stepper_1574098_enabled = 1;
		set_bit(MX_Stepper_1574098_DDR1, MX_Stepper_1574098_PIN1);
		clear_bit(MX_Stepper_1574098_PORT1, MX_Stepper_1574098_PIN1);
		set_bit(MX_Stepper_1574098_DDR2, MX_Stepper_1574098_PIN2);
		clear_bit(MX_Stepper_1574098_PORT2, MX_Stepper_1574098_PIN2);
		set_bit(MX_Stepper_1574098_DDR3, MX_Stepper_1574098_PIN3);
		clear_bit(MX_Stepper_1574098_PORT3, MX_Stepper_1574098_PIN3);
		set_bit(MX_Stepper_1574098_DDR4, MX_Stepper_1574098_PIN4);
		clear_bit(MX_Stepper_1574098_PORT4, MX_Stepper_1574098_PIN4);
}

static void FCD_Stepper0_DisableMotor()
{
		Stepper_1574098_enabled = 0;
		clear_bit(MX_Stepper_1574098_DDR1, MX_Stepper_1574098_PIN1);
		clear_bit(MX_Stepper_1574098_PORT1, MX_Stepper_1574098_PIN1);
		clear_bit(MX_Stepper_1574098_DDR2, MX_Stepper_1574098_PIN2);
		clear_bit(MX_Stepper_1574098_PORT2, MX_Stepper_1574098_PIN2);
		clear_bit(MX_Stepper_1574098_DDR3, MX_Stepper_1574098_PIN3);
		clear_bit(MX_Stepper_1574098_PORT3, MX_Stepper_1574098_PIN3);
		clear_bit(MX_Stepper_1574098_DDR4, MX_Stepper_1574098_PIN4);
		clear_bit(MX_Stepper_1574098_PORT4, MX_Stepper_1574098_PIN4);
}

//Macro implementations

void FCM_right()
{
	
	//Call Component Macro
	//Call Component Macro: LCDDisplay(0)::Cursor(0, 0)
	FCD_LCDDisplay0_Cursor(0, 0);


	//String Manipulation
	//String Manipulation:
	//  right_lcd = "Rotate right"
	FCI_CONCATENATE("Rotate right",12,"",0,FCV_RIGHT_LCD,FCSZ_RIGHT_LCD);
	

	//Call Component Macro
	//Call Component Macro: LCDDisplay(0)::PrintString(right_lcd)
	FCD_LCDDisplay0_PrintString(FCV_RIGHT_LCD,FCSZ_RIGHT_LCD);


}

void FCM_left()
{
	
	//Call Component Macro
	//Call Component Macro: LCDDisplay(0)::Cursor(0, 0)
	FCD_LCDDisplay0_Cursor(0, 0);


	//String Manipulation
	//String Manipulation:
	//  left_lcd = "Rotate left"
	FCI_CONCATENATE("Rotate left",11,"",0,FCV_LEFT_LCD,FCSZ_LEFT_LCD);
	

	//Call Component Macro
	//Call Component Macro: LCDDisplay(0)::PrintString(left_lcd)
	FCD_LCDDisplay0_PrintString(FCV_LEFT_LCD,FCSZ_LEFT_LCD);


}

int main()
{
	
	//Initialisation
	MCUCSR=0x00;
	wdt_disable();


	//Interrupt initialisation code
	
	//Call Component Macro
	//Call Component Macro: LCDDisplay(0)::Start
	FCD_LCDDisplay0_Start();


	//Call Component Macro
	//Call Component Macro: Stepper(0)::EnableMotor
	FCD_Stepper0_EnableMotor();


	//Loop
	//Loop: While 1
	while (1)
	{
		//Input
		//Input: C1 -> right
		DDRC = DDRC & 0xfd;
		FCV_RIGHT = ((PINC & 0x02) == 0x02);


		//Input
		//Input: C0 -> left
		DDRC = DDRC & 0xfe;
		FCV_LEFT = ((PINC & 0x01) == 0x01);


		//Decision
		//Decision: right=1?
		if (FCV_RIGHT==1)
		{
			//Call Component Macro
			//Call Component Macro: Stepper(0)::IncrementStep
			FCD_Stepper0_IncrementStep();


			//Call Macro
			//Call Macro: right
			FCM_right();


		}


		//Decision
		//Decision: left=1?
		if (FCV_LEFT==1)
		{
			//Call Component Macro
			//Call Component Macro: Stepper(0)::DecrementStep
			FCD_Stepper0_DecrementStep();


			//Call Macro
			//Call Macro: left
			FCM_left();


		}


	}


	mainendloop: goto mainendloop;
}



