
;CodeVisionAVR C Compiler V2.04.4a Advanced
;(C) Copyright 1998-2009 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega64
;Program type             : Application
;Clock frequency          : 8.000000 MHz
;Memory model             : Small
;Optimize for             : Size
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 1024 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : Yes
;'char' is unsigned       : Yes
;8 bit enums              : Yes
;global 'const' stored in FLASH: No
;Enhanced core instructions    : On
;Smart register allocation     : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega64
	#pragma AVRPART MEMORY PROG_FLASH 65536
	#pragma AVRPART MEMORY EEPROM 2048
	#pragma AVRPART MEMORY INT_SRAM SIZE 4096
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x100

	.LISTMAC
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F
	.EQU XMCRA=0x6D
	.EQU XMCRB=0x6C

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	CALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	CALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _res=R5
	.DEF _nbytes=R6
	.DEF __lcd_x=R4
	.DEF __lcd_y=R9
	.DEF __lcd_maxx=R8

	.CSEG
	.ORG 0x00

;INTERRUPT VECTORS
	JMP  __RESET
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  _timer_comp_isr
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00

_k1:
	.DB  0x20,0x22,0x2A,0x2B,0x2C,0x5B,0x3D,0x5D
	.DB  0x7C,0x7F,0x0
_tbl10_G102:
	.DB  0x10,0x27,0xE8,0x3,0x64,0x0,0xA,0x0
	.DB  0x1,0x0
_tbl16_G102:
	.DB  0x0,0x10,0x0,0x1,0x10,0x0,0x1,0x0

_0x3:
	.DB  0x45,0x43,0x41,0x20,0x74,0x68,0x65,0x20
	.DB  0x42,0x45,0x53,0x54,0x2E,0x2E
_0x4:
	.DB  0x30,0x3A,0x2F,0x45,0x43,0x41,0x2E,0x74
	.DB  0x78,0x74
_0x0:
	.DB  0x46,0x41,0x54,0x20,0x6D,0x6F,0x75,0x6E
	.DB  0x74,0x65,0x64,0x20,0x3D,0x20,0x4F,0x4B
	.DB  0x0,0x46,0x69,0x6C,0x65,0x20,0x6F,0x70
	.DB  0x65,0x6E,0x65,0x64,0x0,0x57,0x72,0x69
	.DB  0x74,0x69,0x6E,0x67,0x20,0x44,0x61,0x74
	.DB  0x61,0x0,0x46,0x69,0x6C,0x65,0x20,0x63
	.DB  0x6C,0x6F,0x73,0x65,0x64,0x0,0x52,0x65
	.DB  0x61,0x64,0x69,0x6E,0x67,0x20,0x44,0x61
	.DB  0x74,0x61,0x0
_0x2000003:
	.DB  0x1
_0x2020107:
	.DB  0x46,0x41,0x54
_0x2060003:
	.DB  0x80,0xC0

__GLOBAL_INI_TBL:
	.DW  0x0E
	.DW  _buffer
	.DW  _0x3*2

	.DW  0x0A
	.DW  _path
	.DW  _0x4*2

	.DW  0x01
	.DW  _status_G100
	.DW  _0x2000003*2

	.DW  0x03
	.DW  _fatstr_S1010016000
	.DW  _0x2020107*2

	.DW  0x02
	.DW  __base_y_G103
	.DW  _0x2060003*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  MCUCR,R31
	OUT  MCUCR,R30
	STS  XMCRB,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x1000)
	LDI  R25,HIGH(0x1000)
	LDI  R26,LOW(0x100)
	LDI  R27,HIGH(0x100)
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0x10FF)
	OUT  SPL,R30
	LDI  R30,HIGH(0x10FF)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0x500)
	LDI  R29,HIGH(0x500)

	JMP  _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x500

	.CSEG
;
;#include <mega64.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif
;
;#include <ff.h>
;
;#include <stdio.h>
;
;#include <delay.h>
;
;
;#asm
   .equ __lcd_port=0x15 ;PORTC
; 0000 000D #endasm
;#include <lcd.h>
;
;
;#define T1_OVF_FREQ 100
;#define T1_PRESC 1024L
;#define T1_INIT (0x10000L-(_MCU_CLOCK_FREQUENCY_/(T1_PRESC*T1_OVF_FREQ)))
;
;unsigned char buffer[15]="ECA the BEST..";

	.DSEG
;unsigned char buffer2[10];
;unsigned char buffer3[5];
;
;
;
;FRESULT res;
;unsigned int nbytes;
;FATFS fat;
;FIL file;
;char path[]="0:/ECA.txt";
;
;
;
;
;interrupt [TIM1_OVF] void timer_comp_isr(void)
; 0000 0025 {

	.CSEG
_timer_comp_isr:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R15
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 0026 /* re-initialize Timer1 */
; 0000 0027 TCNT1H=T1_INIT>>8;
	LDI  R30,LOW(255)
	OUT  0x2D,R30
; 0000 0028 TCNT1L=T1_INIT&0xFF;
	LDI  R30,LOW(178)
	OUT  0x2C,R30
; 0000 0029 /* card access low level timing function */
; 0000 002A disk_timerproc();
	CALL _disk_timerproc
; 0000 002B }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
;
;
;
;
;void main(void)
; 0000 0031 {
_main:
; 0000 0032 
; 0000 0033 
; 0000 0034 
; 0000 0035 TCCR1A=0x00;
	LDI  R30,LOW(0)
	OUT  0x2F,R30
; 0000 0036 TCCR1B=(1<<CS12)|(1<<CS10);
	LDI  R30,LOW(5)
	OUT  0x2E,R30
; 0000 0037 TCNT1H=T1_INIT>>8;
	LDI  R30,LOW(255)
	OUT  0x2D,R30
; 0000 0038 TCNT1L=T1_INIT&0xFF;
	LDI  R30,LOW(178)
	OUT  0x2C,R30
; 0000 0039 TIMSK=1<<TOIE1;
	LDI  R30,LOW(4)
	OUT  0x37,R30
; 0000 003A 
; 0000 003B 
; 0000 003C 
; 0000 003D 
; 0000 003E #asm("sei")
	sei
; 0000 003F 
; 0000 0040 lcd_init(16);
	LDI  R30,LOW(16)
	ST   -Y,R30
	CALL _lcd_init
; 0000 0041 lcd_clear();
	CALL _lcd_clear
; 0000 0042 
; 0000 0043 
; 0000 0044 
; 0000 0045 
; 0000 0046 if ((res=f_mount(0,&fat))==FR_OK)
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(_fat)
	LDI  R31,HIGH(_fat)
	ST   -Y,R31
	ST   -Y,R30
	CALL _f_mount
	MOV  R5,R30
	CPI  R30,0
	BRNE _0x5
; 0000 0047     lcd_putsf("FAT mounted = OK");
	__POINTW1FN _0x0,0
	CALL SUBOPT_0x0
; 0000 0048 
; 0000 0049 
; 0000 004A delay_ms(1000);
_0x5:
	CALL SUBOPT_0x1
; 0000 004B lcd_clear();
; 0000 004C if ((res=f_open(&file,path,FA_CREATE_ALWAYS))==FR_OK)
	LDI  R30,LOW(_path)
	LDI  R31,HIGH(_path)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(8)
	ST   -Y,R30
	CALL _f_open
	MOV  R5,R30
	CPI  R30,0
	BRNE _0x6
; 0000 004D     lcd_putsf("File opened");
	__POINTW1FN _0x0,17
	CALL SUBOPT_0x0
; 0000 004E 
; 0000 004F 
; 0000 0050 delay_ms(1000);
_0x6:
	CALL SUBOPT_0x1
; 0000 0051 lcd_clear();
; 0000 0052 if ((res=f_write(&file,buffer,15,&nbytes))==FR_OK)
	LDI  R30,LOW(_buffer)
	LDI  R31,HIGH(_buffer)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(15)
	LDI  R31,HIGH(15)
	CALL SUBOPT_0x2
	CALL _f_write
	MOV  R5,R30
	CPI  R30,0
	BRNE _0x7
; 0000 0053     lcd_putsf("Writing Data");
	__POINTW1FN _0x0,29
	CALL SUBOPT_0x0
; 0000 0054 
; 0000 0055 
; 0000 0056 
; 0000 0057 delay_ms(1000);
_0x7:
	CALL SUBOPT_0x1
; 0000 0058 lcd_clear();
; 0000 0059 if ((res=f_close(&file))==FR_OK)
	CALL _f_close
	MOV  R5,R30
	CPI  R30,0
	BRNE _0x8
; 0000 005A    lcd_putsf("File closed");
	__POINTW1FN _0x0,42
	CALL SUBOPT_0x0
; 0000 005B 
; 0000 005C 
; 0000 005D delay_ms(1000);
_0x8:
	CALL SUBOPT_0x1
; 0000 005E lcd_clear();
; 0000 005F if ((res=f_open(&file,path,FA_READ))==FR_OK)
	LDI  R30,LOW(_path)
	LDI  R31,HIGH(_path)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _f_open
	MOV  R5,R30
	CPI  R30,0
	BRNE _0x9
; 0000 0060     lcd_putsf("File opened");
	__POINTW1FN _0x0,17
	CALL SUBOPT_0x0
; 0000 0061 
; 0000 0062 
; 0000 0063 delay_ms(1000);
_0x9:
	CALL SUBOPT_0x1
; 0000 0064 lcd_clear();
; 0000 0065 if ((res=f_read(&file,buffer2,10,&nbytes))==FR_OK)
	LDI  R30,LOW(_buffer2)
	LDI  R31,HIGH(_buffer2)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL SUBOPT_0x2
	CALL _f_read
	MOV  R5,R30
	CPI  R30,0
	BRNE _0xA
; 0000 0066     lcd_putsf("Reading Data");
	__POINTW1FN _0x0,54
	CALL SUBOPT_0x0
; 0000 0067 
; 0000 0068 
; 0000 0069 delay_ms(1000);
_0xA:
	CALL SUBOPT_0x1
; 0000 006A lcd_clear();
; 0000 006B if ((res=f_read(&file,buffer3,5,&nbytes))==FR_OK)
	LDI  R30,LOW(_buffer3)
	LDI  R31,HIGH(_buffer3)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	CALL SUBOPT_0x2
	CALL _f_read
	MOV  R5,R30
	CPI  R30,0
	BRNE _0xB
; 0000 006C     lcd_putsf("Reading Data");
	__POINTW1FN _0x0,54
	CALL SUBOPT_0x0
; 0000 006D 
; 0000 006E 
; 0000 006F delay_ms(1000);
_0xB:
	CALL SUBOPT_0x1
; 0000 0070 lcd_clear();
; 0000 0071 if ((res=f_close(&file))==FR_OK)
	CALL _f_close
	MOV  R5,R30
	CPI  R30,0
	BRNE _0xC
; 0000 0072    lcd_putsf("File closed");
	__POINTW1FN _0x0,42
	CALL SUBOPT_0x0
; 0000 0073 
; 0000 0074 
; 0000 0075 while(1);
_0xC:
_0xD:
	RJMP _0xD
; 0000 0076  }
_0x10:
	RJMP _0x10
;
;
;
;
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif

	.DSEG

	.CSEG
_wait_ready_G100:
	ST   -Y,R17
	LDI  R30,LOW(50)
	STS  _timer2_G100,R30
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x2000004:
	SBIS 0xE,7
	RJMP _0x2000004
_0x2000008:
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x200000A:
	SBIS 0xE,7
	RJMP _0x200000A
	IN   R17,15
	CPI  R17,255
	BREQ _0x200000D
	LDS  R30,_timer2_G100
	CPI  R30,0
	BRNE _0x200000E
_0x200000D:
	RJMP _0x2000009
_0x200000E:
	RJMP _0x2000008
_0x2000009:
	MOV  R30,R17
	LD   R17,Y+
	RET
_release_spi_G100:
	SBI  0x18,0
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x200000F:
	SBIS 0xE,7
	RJMP _0x200000F
	RET
_rx_datablock_G100:
	CALL __SAVELOCR4
	LDI  R30,LOW(10)
	STS  _timer1_G100,R30
_0x2000013:
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x2000015:
	SBIS 0xE,7
	RJMP _0x2000015
	IN   R17,15
	CPI  R17,255
	BRNE _0x2000018
	LDS  R30,_timer1_G100
	CPI  R30,0
	BRNE _0x2000019
_0x2000018:
	RJMP _0x2000014
_0x2000019:
	RJMP _0x2000013
_0x2000014:
	CPI  R17,254
	BREQ _0x200001A
	LDI  R30,LOW(0)
	CALL __LOADLOCR4
	RJMP _0x20C0013
_0x200001A:
	__GETWRS 18,19,6
_0x200001C:
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x200001E:
	SBIS 0xE,7
	RJMP _0x200001E
	PUSH R19
	PUSH R18
	__ADDWRN 18,19,1
	IN   R30,0xF
	POP  R26
	POP  R27
	ST   X,R30
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x2000021:
	SBIS 0xE,7
	RJMP _0x2000021
	PUSH R19
	PUSH R18
	__ADDWRN 18,19,1
	IN   R30,0xF
	POP  R26
	POP  R27
	ST   X,R30
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x2000024:
	SBIS 0xE,7
	RJMP _0x2000024
	PUSH R19
	PUSH R18
	__ADDWRN 18,19,1
	IN   R30,0xF
	POP  R26
	POP  R27
	ST   X,R30
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x2000027:
	SBIS 0xE,7
	RJMP _0x2000027
	PUSH R19
	PUSH R18
	__ADDWRN 18,19,1
	IN   R30,0xF
	POP  R26
	POP  R27
	ST   X,R30
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	SBIW R30,4
	STD  Y+4,R30
	STD  Y+4+1,R31
	BRNE _0x200001C
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x200002A:
	SBIS 0xE,7
	RJMP _0x200002A
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x200002D:
	SBIS 0xE,7
	RJMP _0x200002D
	LDI  R30,LOW(1)
	CALL __LOADLOCR4
	RJMP _0x20C0013
_tx_datablock_G100:
	CALL __SAVELOCR4
	RCALL _wait_ready_G100
	CPI  R30,LOW(0xFF)
	BREQ _0x2000030
	LDI  R30,LOW(0)
	CALL __LOADLOCR4
	RJMP _0x20C0014
_0x2000030:
	LDD  R30,Y+4
	OUT  0xF,R30
_0x2000031:
	SBIS 0xE,7
	RJMP _0x2000031
	LDD  R26,Y+4
	CPI  R26,LOW(0xFD)
	BREQ _0x2000034
	LDI  R16,LOW(0)
	__GETWRS 18,19,5
_0x2000036:
	MOVW R26,R18
	__ADDWRN 18,19,1
	LD   R30,X
	OUT  0xF,R30
_0x2000038:
	SBIS 0xE,7
	RJMP _0x2000038
	MOVW R26,R18
	__ADDWRN 18,19,1
	LD   R30,X
	OUT  0xF,R30
_0x200003B:
	SBIS 0xE,7
	RJMP _0x200003B
	SUBI R16,LOW(1)
	CPI  R16,0
	BRNE _0x2000036
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x200003E:
	SBIS 0xE,7
	RJMP _0x200003E
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x2000041:
	SBIS 0xE,7
	RJMP _0x2000041
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x2000044:
	SBIS 0xE,7
	RJMP _0x2000044
	IN   R17,15
	MOV  R30,R17
	ANDI R30,LOW(0x1F)
	CPI  R30,LOW(0x5)
	BREQ _0x2000047
	LDI  R30,LOW(0)
	CALL __LOADLOCR4
	RJMP _0x20C0014
_0x2000047:
_0x2000034:
	LDI  R30,LOW(1)
	CALL __LOADLOCR4
	RJMP _0x20C0014
_send_cmd_G100:
	ST   -Y,R17
	ST   -Y,R16
	LDD  R30,Y+6
	ANDI R30,LOW(0x80)
	BREQ _0x2000048
	LDD  R30,Y+6
	ANDI R30,0x7F
	STD  Y+6,R30
	LDI  R30,LOW(119)
	ST   -Y,R30
	__GETD1N 0x0
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	MOV  R16,R30
	CPI  R16,2
	BRLO _0x2000049
	MOV  R30,R16
	LDD  R17,Y+1
	LDD  R16,Y+0
	RJMP _0x20C0014
_0x2000049:
_0x2000048:
	SBI  0x18,0
	CBI  0x18,0
	RCALL _wait_ready_G100
	CPI  R30,LOW(0xFF)
	BREQ _0x200004A
	LDI  R30,LOW(255)
	LDD  R17,Y+1
	LDD  R16,Y+0
	RJMP _0x20C0014
_0x200004A:
	LDD  R30,Y+6
	OUT  0xF,R30
_0x200004B:
	SBIS 0xE,7
	RJMP _0x200004B
	LDD  R30,Y+5
	OUT  0xF,R30
_0x200004E:
	SBIS 0xE,7
	RJMP _0x200004E
	LDD  R30,Y+4
	OUT  0xF,R30
_0x2000051:
	SBIS 0xE,7
	RJMP _0x2000051
	LDD  R30,Y+3
	OUT  0xF,R30
_0x2000054:
	SBIS 0xE,7
	RJMP _0x2000054
	LDD  R30,Y+2
	OUT  0xF,R30
_0x2000057:
	SBIS 0xE,7
	RJMP _0x2000057
	LDI  R17,LOW(1)
	LDD  R26,Y+6
	CPI  R26,LOW(0x40)
	BRNE _0x200005A
	LDI  R17,LOW(149)
	RJMP _0x200005B
_0x200005A:
	LDD  R26,Y+6
	CPI  R26,LOW(0x48)
	BRNE _0x200005C
	LDI  R17,LOW(135)
_0x200005C:
_0x200005B:
	OUT  0xF,R17
_0x200005D:
	SBIS 0xE,7
	RJMP _0x200005D
	LDD  R26,Y+6
	CPI  R26,LOW(0x4C)
	BRNE _0x2000060
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x2000061:
	SBIS 0xE,7
	RJMP _0x2000061
_0x2000060:
	LDI  R17,LOW(255)
_0x2000065:
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x2000067:
	SBIS 0xE,7
	RJMP _0x2000067
	IN   R16,15
	SBRS R16,7
	RJMP _0x200006A
	SUBI R17,LOW(1)
	CPI  R17,0
	BRNE _0x200006B
_0x200006A:
	RJMP _0x2000066
_0x200006B:
	RJMP _0x2000065
_0x2000066:
	MOV  R30,R16
	LDD  R17,Y+1
	LDD  R16,Y+0
	RJMP _0x20C0014
_rx_spi4_G100:
	ST   -Y,R17
	LDI  R17,4
_0x200006D:
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x200006F:
	SBIS 0xE,7
	RJMP _0x200006F
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	ADIW R26,1
	STD  Y+1,R26
	STD  Y+1+1,R27
	SBIW R26,1
	IN   R30,0xF
	ST   X,R30
	SUBI R17,LOW(1)
	CPI  R17,0
	BRNE _0x200006D
	RJMP _0x20C0012
_disk_initialize:
	SBIW R28,4
	CALL __SAVELOCR4
	LDD  R30,Y+8
	CPI  R30,0
	BREQ _0x2000072
	LDI  R30,LOW(1)
	RJMP _0x20C0018
_0x2000072:
	CBI  0x1A,1
	CBI  0x1A,0
	LDI  R30,LOW(10)
	STS  _timer1_G100,R30
_0x2000073:
	LDS  R30,_timer1_G100
	CPI  R30,0
	BRNE _0x2000073
	LDS  R30,_status_G100
	ANDI R30,LOW(0x2)
	BREQ _0x2000076
	RJMP _0x20C0017
_0x2000076:
	SBI  0x17,0
	SBI  0x18,0
	IN   R30,0x18
	ANDI R30,LOW(0xF9)
	OUT  0x18,R30
	SBI  0x18,3
	CBI  0x17,3
	IN   R30,0x17
	ORI  R30,LOW(0x7)
	OUT  0x17,R30
	LDI  R30,LOW(82)
	OUT  0xD,R30
	LDI  R30,LOW(0)
	OUT  0xE,R30
	LDI  R19,LOW(255)
_0x2000078:
	LDI  R17,LOW(10)
_0x200007B:
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x200007D:
	SBIS 0xE,7
	RJMP _0x200007D
	SUBI R17,LOW(1)
	CPI  R17,0
	BRNE _0x200007B
	LDI  R30,LOW(64)
	ST   -Y,R30
	__GETD1N 0x0
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	MOV  R16,R30
	SUBI R19,LOW(1)
	CPI  R16,1
	BREQ _0x2000080
	CPI  R19,0
	BRNE _0x2000081
_0x2000080:
	RJMP _0x2000079
_0x2000081:
	RJMP _0x2000078
_0x2000079:
	LDI  R19,LOW(0)
	CPI  R16,1
	BREQ PC+3
	JMP _0x2000082
	LDI  R30,LOW(100)
	STS  _timer1_G100,R30
	LDI  R30,LOW(72)
	ST   -Y,R30
	__GETD1N 0x1AA
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,LOW(0x1)
	BRNE _0x2000083
	MOVW R30,R28
	ADIW R30,4
	ST   -Y,R31
	ST   -Y,R30
	RCALL _rx_spi4_G100
	LDD  R26,Y+6
	CPI  R26,LOW(0x1)
	BRNE _0x2000085
	LDD  R26,Y+7
	CPI  R26,LOW(0xAA)
	BREQ _0x2000086
_0x2000085:
	RJMP _0x2000084
_0x2000086:
_0x2000087:
	LDS  R30,_timer1_G100
	CPI  R30,0
	BREQ _0x200008A
	LDI  R30,LOW(233)
	ST   -Y,R30
	__GETD1N 0x40000000
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,0
	BRNE _0x200008B
_0x200008A:
	RJMP _0x2000089
_0x200008B:
	RJMP _0x2000087
_0x2000089:
	LDS  R30,_timer1_G100
	CPI  R30,0
	BREQ _0x200008D
	LDI  R30,LOW(122)
	ST   -Y,R30
	__GETD1N 0x0
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,0
	BREQ _0x200008E
_0x200008D:
	RJMP _0x200008C
_0x200008E:
	MOVW R30,R28
	ADIW R30,4
	ST   -Y,R31
	ST   -Y,R30
	RCALL _rx_spi4_G100
	LDD  R30,Y+4
	ANDI R30,LOW(0x40)
	BREQ _0x200008F
	LDI  R30,LOW(12)
	RJMP _0x2000090
_0x200008F:
	LDI  R30,LOW(4)
_0x2000090:
	MOV  R19,R30
_0x200008C:
_0x2000084:
	RJMP _0x2000092
_0x2000083:
	LDI  R30,LOW(233)
	ST   -Y,R30
	__GETD1N 0x0
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,LOW(0x2)
	BRSH _0x2000093
	LDI  R19,LOW(2)
	LDI  R16,LOW(233)
	RJMP _0x2000094
_0x2000093:
	LDI  R19,LOW(1)
	LDI  R16,LOW(65)
_0x2000094:
_0x2000095:
	LDS  R30,_timer1_G100
	CPI  R30,0
	BREQ _0x2000098
	ST   -Y,R16
	__GETD1N 0x0
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,0
	BRNE _0x2000099
_0x2000098:
	RJMP _0x2000097
_0x2000099:
	RJMP _0x2000095
_0x2000097:
	LDS  R30,_timer1_G100
	CPI  R30,0
	BREQ _0x200009B
	LDI  R30,LOW(80)
	ST   -Y,R30
	__GETD1N 0x200
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,0
	BREQ _0x200009A
_0x200009B:
	LDI  R19,LOW(0)
_0x200009A:
_0x2000092:
_0x2000082:
	STS  _card_type_G100,R19
	RCALL _release_spi_G100
	CPI  R19,0
	BREQ _0x200009D
	LDS  R30,_status_G100
	ANDI R30,0xFE
	STS  _status_G100,R30
	LDI  R30,LOW(80)
	OUT  0xD,R30
	LDI  R30,LOW(1)
	OUT  0xE,R30
	RJMP _0x200009E
_0x200009D:
	CBI  0x18,0
	RCALL _wait_ready_G100
	RCALL _release_spi_G100
	LDI  R30,LOW(0)
	OUT  0xD,R30
	IN   R30,0x17
	ANDI R30,LOW(0xF0)
	OUT  0x17,R30
	IN   R30,0x18
	ANDI R30,LOW(0xF0)
	OUT  0x18,R30
	CBI  0x17,0
	LDS  R30,_status_G100
	ORI  R30,1
	STS  _status_G100,R30
_0x200009E:
_0x20C0017:
	LDS  R30,_status_G100
_0x20C0018:
	CALL __LOADLOCR4
	ADIW R28,9
	RET
_disk_status:
	LD   R30,Y
	CPI  R30,0
	BREQ _0x200009F
	LDI  R30,LOW(1)
	RJMP _0x20C0016
_0x200009F:
	LDS  R30,_status_G100
_0x20C0016:
	ADIW R28,1
	RET
_disk_read:
	LDD  R30,Y+7
	CPI  R30,0
	BRNE _0x20000A1
	LD   R30,Y
	CPI  R30,0
	BRNE _0x20000A0
_0x20000A1:
	LDI  R30,LOW(4)
	RJMP _0x20C0013
_0x20000A0:
	LDS  R30,_status_G100
	ANDI R30,LOW(0x1)
	BREQ _0x20000A3
	LDI  R30,LOW(3)
	RJMP _0x20C0013
_0x20000A3:
	LDS  R30,_card_type_G100
	ANDI R30,LOW(0x8)
	BRNE _0x20000A4
	__GETD1S 1
	__GETD2N 0x200
	CALL __MULD12U
	__PUTD1S 1
_0x20000A4:
	LD   R26,Y
	CPI  R26,LOW(0x1)
	BRNE _0x20000A5
	LDI  R30,LOW(81)
	ST   -Y,R30
	__GETD1S 2
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,0
	BRNE _0x20000A7
	LDD  R30,Y+5
	LDD  R31,Y+5+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(512)
	LDI  R31,HIGH(512)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _rx_datablock_G100
	CPI  R30,0
	BRNE _0x20000A8
_0x20000A7:
	RJMP _0x20000A6
_0x20000A8:
	LDI  R30,LOW(0)
	ST   Y,R30
_0x20000A6:
	RJMP _0x20000A9
_0x20000A5:
	LDI  R30,LOW(82)
	ST   -Y,R30
	__GETD1S 2
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,0
	BRNE _0x20000AA
_0x20000AC:
	LDD  R30,Y+5
	LDD  R31,Y+5+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(512)
	LDI  R31,HIGH(512)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _rx_datablock_G100
	CPI  R30,0
	BREQ _0x20000AD
	LDD  R30,Y+5
	LDD  R31,Y+5+1
	SUBI R30,LOW(-512)
	SBCI R31,HIGH(-512)
	STD  Y+5,R30
	STD  Y+5+1,R31
	LD   R30,Y
	SUBI R30,LOW(1)
	ST   Y,R30
	BRNE _0x20000AC
_0x20000AD:
	LDI  R30,LOW(76)
	ST   -Y,R30
	__GETD1N 0x0
	CALL __PUTPARD1
	RCALL _send_cmd_G100
_0x20000AA:
_0x20000A9:
	RCALL _release_spi_G100
	LD   R30,Y
	CPI  R30,0
	BREQ _0x20000AF
	LDI  R30,LOW(1)
	RJMP _0x20000B0
_0x20000AF:
	LDI  R30,LOW(0)
_0x20000B0:
	RJMP _0x20C0013
_disk_write:
	LDD  R30,Y+7
	CPI  R30,0
	BRNE _0x20000B3
	LD   R30,Y
	CPI  R30,0
	BRNE _0x20000B2
_0x20000B3:
	LDI  R30,LOW(4)
	RJMP _0x20C0013
_0x20000B2:
	LDS  R30,_status_G100
	ANDI R30,LOW(0x1)
	BREQ _0x20000B5
	LDI  R30,LOW(3)
	RJMP _0x20C0013
_0x20000B5:
	LDS  R30,_status_G100
	ANDI R30,LOW(0x4)
	BREQ _0x20000B6
	LDI  R30,LOW(2)
	RJMP _0x20C0013
_0x20000B6:
	LDS  R30,_card_type_G100
	ANDI R30,LOW(0x8)
	BRNE _0x20000B7
	__GETD1S 1
	__GETD2N 0x200
	CALL __MULD12U
	__PUTD1S 1
_0x20000B7:
	LD   R26,Y
	CPI  R26,LOW(0x1)
	BRNE _0x20000B8
	LDI  R30,LOW(88)
	ST   -Y,R30
	__GETD1S 2
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,0
	BRNE _0x20000BA
	LDD  R30,Y+5
	LDD  R31,Y+5+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(254)
	ST   -Y,R30
	RCALL _tx_datablock_G100
	CPI  R30,0
	BRNE _0x20000BB
_0x20000BA:
	RJMP _0x20000B9
_0x20000BB:
	LDI  R30,LOW(0)
	ST   Y,R30
_0x20000B9:
	RJMP _0x20000BC
_0x20000B8:
	LDS  R30,_card_type_G100
	ANDI R30,LOW(0x6)
	BREQ _0x20000BD
	LDI  R30,LOW(215)
	ST   -Y,R30
	LDD  R30,Y+1
	CLR  R31
	CLR  R22
	CLR  R23
	CALL __PUTPARD1
	RCALL _send_cmd_G100
_0x20000BD:
	LDI  R30,LOW(89)
	ST   -Y,R30
	__GETD1S 2
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,0
	BRNE _0x20000BE
_0x20000C0:
	LDD  R30,Y+5
	LDD  R31,Y+5+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(252)
	ST   -Y,R30
	RCALL _tx_datablock_G100
	CPI  R30,0
	BREQ _0x20000C1
	LDD  R30,Y+5
	LDD  R31,Y+5+1
	SUBI R30,LOW(-512)
	SBCI R31,HIGH(-512)
	STD  Y+5,R30
	STD  Y+5+1,R31
	LD   R30,Y
	SUBI R30,LOW(1)
	ST   Y,R30
	BRNE _0x20000C0
_0x20000C1:
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(253)
	ST   -Y,R30
	RCALL _tx_datablock_G100
	CPI  R30,0
	BRNE _0x20000C3
	LDI  R30,LOW(1)
	ST   Y,R30
_0x20000C3:
_0x20000BE:
_0x20000BC:
	RCALL _release_spi_G100
	LD   R30,Y
	CPI  R30,0
	BREQ _0x20000C4
	LDI  R30,LOW(1)
	RJMP _0x20000C5
_0x20000C4:
	LDI  R30,LOW(0)
_0x20000C5:
	RJMP _0x20C0013
_disk_ioctl:
	SBIW R28,16
	CALL __SAVELOCR6
	LDD  R30,Y+25
	CPI  R30,0
	BREQ _0x20000C7
	LDI  R30,LOW(4)
	RJMP _0x20C0015
_0x20000C7:
	LDI  R17,LOW(1)
	LDS  R30,_status_G100
	ANDI R30,LOW(0x1)
	BREQ _0x20000C8
	LDI  R30,LOW(3)
	RJMP _0x20C0015
_0x20000C8:
	__GETWRS 20,21,22
	LDD  R30,Y+24
	CPI  R30,0
	BRNE _0x20000CC
	CBI  0x18,0
	RCALL _wait_ready_G100
	CPI  R30,LOW(0xFF)
	BRNE _0x20000CD
	LDI  R17,LOW(0)
_0x20000CD:
	RJMP _0x20000CB
_0x20000CC:
	CPI  R30,LOW(0x1)
	BREQ PC+3
	JMP _0x20000CE
	LDI  R30,LOW(73)
	ST   -Y,R30
	__GETD1N 0x0
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,0
	BRNE _0x20000D0
	MOVW R30,R28
	ADIW R30,6
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(16)
	LDI  R31,HIGH(16)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _rx_datablock_G100
	CPI  R30,0
	BRNE _0x20000D1
_0x20000D0:
	RJMP _0x20000CF
_0x20000D1:
	LDD  R30,Y+6
	SWAP R30
	ANDI R30,0xF
	LSR  R30
	LSR  R30
	CPI  R30,LOW(0x1)
	BRNE _0x20000D2
	LDI  R30,0
	LDD  R31,Y+14
	LDD  R26,Y+15
	LDI  R27,0
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,1
	MOVW R18,R30
	MOVW R26,R18
	CLR  R24
	CLR  R25
	LDI  R30,LOW(10)
	RJMP _0x2000101
_0x20000D2:
	LDD  R30,Y+11
	ANDI R30,LOW(0xF)
	MOV  R26,R30
	LDD  R30,Y+16
	ANDI R30,LOW(0x80)
	ROL  R30
	LDI  R30,0
	ROL  R30
	ADD  R26,R30
	LDD  R30,Y+15
	ANDI R30,LOW(0x3)
	LSL  R30
	ADD  R30,R26
	SUBI R30,-LOW(2)
	MOV  R16,R30
	LDD  R30,Y+14
	SWAP R30
	ANDI R30,0xF
	LSR  R30
	LSR  R30
	MOV  R26,R30
	LDD  R30,Y+13
	LDI  R31,0
	CALL __LSLW2
	LDI  R27,0
	ADD  R26,R30
	ADC  R27,R31
	LDD  R30,Y+12
	ANDI R30,LOW(0x3)
	LDI  R31,0
	CALL __LSLW2
	MOV  R31,R30
	LDI  R30,0
	ADD  R30,R26
	ADC  R31,R27
	ADIW R30,1
	MOVW R18,R30
	MOVW R26,R18
	CLR  R24
	CLR  R25
	MOV  R30,R16
	SUBI R30,LOW(9)
_0x2000101:
	CALL __LSLD12
	MOVW R26,R20
	CALL __PUTDP1
	LDI  R17,LOW(0)
_0x20000CF:
	RJMP _0x20000CB
_0x20000CE:
	CPI  R30,LOW(0x2)
	BRNE _0x20000D4
	MOVW R26,R20
	LDI  R30,LOW(512)
	LDI  R31,HIGH(512)
	ST   X+,R30
	ST   X,R31
	LDI  R17,LOW(0)
	RJMP _0x20000CB
_0x20000D4:
	CPI  R30,LOW(0x3)
	BREQ PC+3
	JMP _0x20000D5
	LDS  R30,_card_type_G100
	ANDI R30,LOW(0x4)
	BREQ _0x20000D6
	LDI  R30,LOW(205)
	ST   -Y,R30
	__GETD1N 0x0
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,0
	BRNE _0x20000D7
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x20000D8:
	SBIS 0xE,7
	RJMP _0x20000D8
	MOVW R30,R28
	ADIW R30,6
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(16)
	LDI  R31,HIGH(16)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _rx_datablock_G100
	CPI  R30,0
	BREQ _0x20000DB
	LDI  R16,LOW(48)
_0x20000DD:
	CPI  R16,0
	BREQ _0x20000DE
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x20000DF:
	SBIS 0xE,7
	RJMP _0x20000DF
	SUBI R16,1
	RJMP _0x20000DD
_0x20000DE:
	LDD  R30,Y+16
	SWAP R30
	ANDI R30,0xF
	__GETD2N 0x10
	CALL __LSLD12
	MOVW R26,R20
	CALL __PUTDP1
	LDI  R17,LOW(0)
_0x20000DB:
_0x20000D7:
	RJMP _0x20000E2
_0x20000D6:
	LDI  R30,LOW(73)
	ST   -Y,R30
	__GETD1N 0x0
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,0
	BRNE _0x20000E4
	MOVW R30,R28
	ADIW R30,6
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(16)
	LDI  R31,HIGH(16)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _rx_datablock_G100
	CPI  R30,0
	BRNE _0x20000E5
_0x20000E4:
	RJMP _0x20000E3
_0x20000E5:
	LDS  R30,_card_type_G100
	ANDI R30,LOW(0x2)
	BREQ _0x20000E6
	LDD  R30,Y+16
	ANDI R30,LOW(0x3F)
	CLR  R31
	CLR  R22
	CLR  R23
	CALL __LSLD1
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	LDD  R30,Y+17
	ANDI R30,LOW(0x80)
	CLR  R31
	CLR  R22
	CLR  R23
	MOVW R26,R30
	MOVW R24,R22
	LDI  R30,LOW(7)
	CALL __LSRD12
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL __ADDD12
	__ADDD1N 1
	MOVW R26,R30
	MOVW R24,R22
	LDD  R30,Y+19
	SWAP R30
	ANDI R30,0xF
	LSR  R30
	LSR  R30
	SUBI R30,LOW(1)
	CALL __LSLD12
	RJMP _0x2000102
_0x20000E6:
	LDD  R30,Y+16
	ANDI R30,LOW(0x7C)
	LSR  R30
	LSR  R30
	CLR  R31
	CLR  R22
	CLR  R23
	__ADDD1N 1
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	LDD  R30,Y+17
	ANDI R30,LOW(0x3)
	CLR  R31
	CLR  R22
	CLR  R23
	MOVW R26,R30
	MOVW R24,R22
	LDI  R30,LOW(3)
	CALL __LSLD12
	MOVW R26,R30
	MOVW R24,R22
	LDD  R30,Y+17
	ANDI R30,LOW(0xE0)
	SWAP R30
	ANDI R30,0xF
	LSR  R30
	CLR  R31
	CLR  R22
	CLR  R23
	CALL __ADDD12
	__ADDD1N 1
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL __MULD12U
_0x2000102:
	MOVW R26,R20
	CALL __PUTDP1
	LDI  R17,LOW(0)
_0x20000E3:
_0x20000E2:
	RJMP _0x20000CB
_0x20000D5:
	CPI  R30,LOW(0xA)
	BRNE _0x20000E8
	LDS  R30,_card_type_G100
	MOVW R26,R20
	ST   X,R30
	LDI  R17,LOW(0)
	RJMP _0x20000CB
_0x20000E8:
	CPI  R30,LOW(0xB)
	BRNE _0x20000E9
	LDI  R30,LOW(73)
	ST   -Y,R30
	__GETD1N 0x0
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,0
	BRNE _0x20000EB
	ST   -Y,R21
	ST   -Y,R20
	LDI  R30,LOW(16)
	LDI  R31,HIGH(16)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _rx_datablock_G100
	CPI  R30,0
	BRNE _0x20000EC
_0x20000EB:
	RJMP _0x20000EA
_0x20000EC:
	LDI  R17,LOW(0)
_0x20000EA:
	RJMP _0x20000CB
_0x20000E9:
	CPI  R30,LOW(0xC)
	BRNE _0x20000ED
	LDI  R30,LOW(74)
	ST   -Y,R30
	__GETD1N 0x0
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,0
	BRNE _0x20000EF
	ST   -Y,R21
	ST   -Y,R20
	LDI  R30,LOW(16)
	LDI  R31,HIGH(16)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _rx_datablock_G100
	CPI  R30,0
	BRNE _0x20000F0
_0x20000EF:
	RJMP _0x20000EE
_0x20000F0:
	LDI  R17,LOW(0)
_0x20000EE:
	RJMP _0x20000CB
_0x20000ED:
	CPI  R30,LOW(0xD)
	BRNE _0x20000F1
	LDI  R30,LOW(122)
	ST   -Y,R30
	__GETD1N 0x0
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,0
	BRNE _0x20000F2
	ST   -Y,R21
	ST   -Y,R20
	RCALL _rx_spi4_G100
	LDI  R17,LOW(0)
_0x20000F2:
	RJMP _0x20000CB
_0x20000F1:
	CPI  R30,LOW(0xE)
	BRNE _0x20000F9
	LDI  R30,LOW(205)
	ST   -Y,R30
	__GETD1N 0x0
	CALL __PUTPARD1
	RCALL _send_cmd_G100
	CPI  R30,0
	BRNE _0x20000F4
	LDI  R30,LOW(255)
	OUT  0xF,R30
_0x20000F5:
	SBIS 0xE,7
	RJMP _0x20000F5
	ST   -Y,R21
	ST   -Y,R20
	LDI  R30,LOW(64)
	LDI  R31,HIGH(64)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _rx_datablock_G100
	CPI  R30,0
	BREQ _0x20000F8
	LDI  R17,LOW(0)
_0x20000F8:
_0x20000F4:
	RJMP _0x20000CB
_0x20000F9:
	LDI  R17,LOW(4)
_0x20000CB:
	RCALL _release_spi_G100
	MOV  R30,R17
_0x20C0015:
	CALL __LOADLOCR6
	ADIW R28,26
	RET
_disk_timerproc:
	ST   -Y,R17
	ST   -Y,R16
	LDS  R17,_timer1_G100
	CPI  R17,0
	BREQ _0x20000FA
	SUBI R17,LOW(1)
	STS  _timer1_G100,R17
_0x20000FA:
	LDS  R17,_timer2_G100
	CPI  R17,0
	BREQ _0x20000FB
	SUBI R17,LOW(1)
	STS  _timer2_G100,R17
_0x20000FB:
	LDS  R17,_pv_S100000B000
	IN   R30,0x19
	ANDI R30,LOW(0x1)
	MOV  R26,R30
	IN   R30,0x19
	ANDI R30,LOW(0x2)
	OR   R30,R26
	STS  _pv_S100000B000,R30
	CP   R30,R17
	BRNE _0x20000FC
	LDS  R16,_status_G100
	ANDI R30,LOW(0x1)
	BREQ _0x20000FD
	ORI  R16,LOW(4)
	RJMP _0x20000FE
_0x20000FD:
	ANDI R16,LOW(251)
_0x20000FE:
	LDS  R30,_pv_S100000B000
	ANDI R30,LOW(0x2)
	BREQ _0x20000FF
	ORI  R16,LOW(3)
	RJMP _0x2000100
_0x20000FF:
	ANDI R16,LOW(253)
_0x2000100:
	STS  _status_G100,R16
_0x20000FC:
	LD   R16,Y+
	LD   R17,Y+
	RET

	.CSEG
_get_fattime:
	SBIW R28,7
	LDS  R26,_prtc_get_time
	LDS  R27,_prtc_get_time+1
	SBIW R26,0
	BREQ _0x2020004
	LDS  R26,_prtc_get_date
	LDS  R27,_prtc_get_date+1
	SBIW R26,0
	BRNE _0x2020003
_0x2020004:
	__GETD1N 0x3A210000
	RJMP _0x20C0014
_0x2020003:
	MOVW R30,R28
	ADIW R30,6
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,7
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,8
	ST   -Y,R31
	ST   -Y,R30
	__CALL1MN _prtc_get_time,0
	MOVW R30,R28
	ADIW R30,3
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,4
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,4
	ST   -Y,R31
	ST   -Y,R30
	__CALL1MN _prtc_get_date,0
	LD   R30,Y
	LDD  R31,Y+1
	SUBI R30,LOW(1980)
	SBCI R31,HIGH(1980)
	CLR  R22
	CLR  R23
	MOVW R26,R30
	MOVW R24,R22
	LDI  R30,LOW(25)
	CALL __LSLD12
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	LDD  R30,Y+2
	CALL SUBOPT_0x3
	MOVW R26,R30
	MOVW R24,R22
	LDI  R30,LOW(21)
	CALL __LSLD12
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL __ORD12
	MOVW R26,R30
	MOVW R24,R22
	LDD  R30,Y+3
	CALL SUBOPT_0x3
	CALL __LSLD16
	CALL __ORD12
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	LDD  R30,Y+6
	CALL SUBOPT_0x3
	MOVW R26,R30
	MOVW R24,R22
	LDI  R30,LOW(11)
	CALL __LSLD12
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL __ORD12
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	LDD  R30,Y+5
	CALL SUBOPT_0x3
	MOVW R26,R30
	MOVW R24,R22
	LDI  R30,LOW(5)
	CALL __LSLD12
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL __ORD12
	MOVW R26,R30
	MOVW R24,R22
	LDD  R30,Y+4
	LDI  R31,0
	ASR  R31
	ROR  R30
	CALL __CWD1
	CALL __ORD12
_0x20C0014:
	ADIW R28,7
	RET
_mem_cpy_G101:
	CALL __SAVELOCR4
	__GETWRS 16,17,8
	__GETWRS 18,19,6
_0x2020006:
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	SBIW R30,1
	STD  Y+4,R30
	STD  Y+4+1,R31
	ADIW R30,1
	BREQ _0x2020008
	PUSH R17
	PUSH R16
	__ADDWRN 16,17,1
	MOVW R26,R18
	__ADDWRN 18,19,1
	LD   R30,X
	POP  R26
	POP  R27
	ST   X,R30
	RJMP _0x2020006
_0x2020008:
	CALL __LOADLOCR4
	RJMP _0x20C000F
_mem_set_G101:
	ST   -Y,R17
	ST   -Y,R16
	__GETWRS 16,17,6
_0x202000C:
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	SBIW R30,1
	STD  Y+2,R30
	STD  Y+2+1,R31
	ADIW R30,1
	BREQ _0x202000E
	PUSH R17
	PUSH R16
	__ADDWRN 16,17,1
	LDD  R30,Y+4
	POP  R26
	POP  R27
	ST   X,R30
	RJMP _0x202000C
_0x202000E:
	LDD  R17,Y+1
	LDD  R16,Y+0
_0x20C0013:
	ADIW R28,8
	RET
_mem_cmp_G101:
	CALL __SAVELOCR6
	__GETWRS 16,17,10
	__GETWRS 18,19,8
	__GETWRN 20,21,0
_0x202000F:
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	SBIW R30,1
	STD  Y+6,R30
	STD  Y+6+1,R31
	ADIW R30,1
	BREQ _0x2020012
	MOVW R26,R16
	__ADDWRN 16,17,1
	LD   R0,X
	CLR  R1
	MOVW R26,R18
	__ADDWRN 18,19,1
	LD   R26,X
	CLR  R27
	MOVW R30,R0
	SUB  R30,R26
	SBC  R31,R27
	MOVW R20,R30
	SBIW R30,0
	BREQ _0x2020013
_0x2020012:
	RJMP _0x2020011
_0x2020013:
	RJMP _0x202000F
_0x2020011:
	MOVW R30,R20
	CALL __LOADLOCR6
	ADIW R28,12
	RET
_chk_chrf_G101:
_0x2020014:
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	LPM  R30,Z
	CPI  R30,0
	BREQ _0x2020017
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	LPM  R26,Z
	LD   R30,Y
	LDD  R31,Y+1
	LDI  R27,0
	CP   R30,R26
	CPC  R31,R27
	BRNE _0x2020018
_0x2020017:
	RJMP _0x2020016
_0x2020018:
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	ADIW R30,1
	STD  Y+2,R30
	STD  Y+2+1,R31
	RJMP _0x2020014
_0x2020016:
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	LPM  R30,Z
	LDI  R31,0
	ADIW R28,4
	RET
_move_window_G101:
	SBIW R28,4
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	ADIW R26,46
	CALL SUBOPT_0x4
	CALL SUBOPT_0x5
	CALL SUBOPT_0x6
	CALL __CPD12
	BRNE PC+3
	JMP _0x2020019
	CALL SUBOPT_0x7
	CPI  R30,0
	BRNE PC+3
	JMP _0x202001A
	CALL SUBOPT_0x8
	CALL SUBOPT_0x9
	CALL SUBOPT_0xA
	CPI  R30,0
	BREQ _0x202001B
	LDI  R30,LOW(1)
	RJMP _0x20C000F
_0x202001B:
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	ADIW R26,4
	LDI  R30,LOW(0)
	ST   X,R30
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	CALL SUBOPT_0xB
	MOVW R0,R26
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	ADIW R26,26
	CALL __GETD1P
	MOVW R26,R0
	CALL __ADDD12
	CALL SUBOPT_0x6
	CALL __CPD21
	BRSH _0x202001C
	SBIW R28,1
	LDD  R26,Y+9
	LDD  R27,Y+9+1
	ADIW R26,3
	LD   R30,X
	ST   Y,R30
_0x202001E:
	LD   R26,Y
	CPI  R26,LOW(0x2)
	BRLO _0x202001F
	LDD  R26,Y+9
	LDD  R27,Y+9+1
	ADIW R26,26
	CALL __GETD1P
	CALL SUBOPT_0xC
	CALL __ADDD12
	__PUTD1S 1
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	LDD  R26,Z+1
	ST   -Y,R26
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	ADIW R30,50
	CALL SUBOPT_0xD
	CALL SUBOPT_0xA
	LD   R30,Y
	SUBI R30,LOW(1)
	ST   Y,R30
	RJMP _0x202001E
_0x202001F:
	ADIW R28,1
_0x202001C:
_0x202001A:
	CALL SUBOPT_0x5
	CALL __CPD10
	BREQ _0x2020020
	CALL SUBOPT_0x8
	CALL SUBOPT_0xE
	CALL SUBOPT_0xF
	BREQ _0x2020021
	LDI  R30,LOW(1)
	RJMP _0x20C000F
_0x2020021:
	CALL SUBOPT_0x5
	__PUTD1SNS 8,46
_0x2020020:
_0x2020019:
	LDI  R30,LOW(0)
	RJMP _0x20C000F
_sync_G101:
	ST   -Y,R17
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	CALL SUBOPT_0x10
	MOV  R17,R30
	CPI  R17,0
	BREQ PC+3
	JMP _0x2020022
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	LD   R26,X
	CPI  R26,LOW(0x3)
	BRNE _0x2020024
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	ADIW R26,9
	LD   R30,X
	CPI  R30,0
	BRNE _0x2020025
_0x2020024:
	RJMP _0x2020023
_0x2020025:
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	CALL SUBOPT_0x11
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	CALL SUBOPT_0x12
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ADIW R30,50
	SUBI R30,LOW(-510)
	SBCI R31,HIGH(-510)
	LDI  R26,LOW(43605)
	LDI  R27,HIGH(43605)
	STD  Z+0,R26
	STD  Z+1,R27
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ADIW R30,50
	__GETD2N 0x41615252
	CALL SUBOPT_0x13
	SUBI R30,LOW(-484)
	SBCI R31,HIGH(-484)
	__GETD2N 0x61417272
	CALL SUBOPT_0x13
	SUBI R30,LOW(-488)
	SBCI R31,HIGH(-488)
	MOVW R0,R30
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	ADIW R26,14
	CALL SUBOPT_0x14
	ADIW R30,50
	SUBI R30,LOW(-492)
	SBCI R31,HIGH(-492)
	MOVW R0,R30
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	ADIW R26,10
	CALL SUBOPT_0x14
	LDD  R26,Z+1
	ST   -Y,R26
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	ADIW R30,50
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	CALL SUBOPT_0x15
	CALL SUBOPT_0x16
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	ADIW R26,9
	LDI  R30,LOW(0)
	ST   X,R30
_0x2020023:
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	LDD  R26,Z+1
	ST   -Y,R26
	LDI  R30,LOW(0)
	ST   -Y,R30
	CALL SUBOPT_0x17
	RCALL _disk_ioctl
	CPI  R30,0
	BREQ _0x2020026
	LDI  R17,LOW(1)
_0x2020026:
_0x2020022:
	MOV  R30,R17
_0x20C0012:
	LDD  R17,Y+0
	ADIW R28,3
	RET
_get_fat_G101:
	SBIW R28,4
	CALL __SAVELOCR4
	CALL SUBOPT_0x18
	CALL SUBOPT_0x19
	BRLO _0x2020028
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	ADIW R26,30
	CALL __GETD1P
	CALL SUBOPT_0x18
	CALL __CPD21
	BRLO _0x2020027
_0x2020028:
	CALL SUBOPT_0x1A
	RJMP _0x20C0011
_0x2020027:
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	ADIW R26,34
	CALL SUBOPT_0x1B
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	CALL SUBOPT_0x1C
	BRNE _0x202002D
	__GETWRS 18,19,8
	MOVW R30,R18
	LSR  R31
	ROR  R30
	__ADDWRR 18,19,30,31
	CALL SUBOPT_0x1D
	BREQ _0x202002E
	RJMP _0x202002C
_0x202002E:
	CALL SUBOPT_0x1E
	LD   R16,X
	CLR  R17
	__ADDWRN 18,19,1
	CALL SUBOPT_0x1D
	BRNE _0x202002C
	CALL SUBOPT_0x1E
	LD   R30,X
	MOV  R31,R30
	LDI  R30,0
	__ORWRR 16,17,30,31
	CALL SUBOPT_0x1F
	ANDI R30,LOW(0x1)
	BREQ _0x2020030
	MOVW R30,R16
	CALL __LSRW4
	RJMP _0x2020229
_0x2020030:
	MOVW R30,R16
	ANDI R31,HIGH(0xFFF)
_0x2020229:
	CLR  R22
	CLR  R23
	RJMP _0x20C0011
_0x202002D:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x2020033
	CALL SUBOPT_0x20
	CALL SUBOPT_0x21
	CALL SUBOPT_0x22
	BRNE _0x202002C
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	LDI  R30,LOW(2)
	CALL SUBOPT_0x23
	CALL SUBOPT_0x24
	RJMP _0x20C0011
_0x2020033:
	CPI  R30,LOW(0x3)
	LDI  R26,HIGH(0x3)
	CPC  R31,R26
	BRNE _0x202002C
	CALL SUBOPT_0x20
	CALL SUBOPT_0x25
	CALL SUBOPT_0x22
	BRNE _0x202002C
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	LDI  R30,LOW(4)
	CALL SUBOPT_0x23
	CALL __GETD1P
	__ANDD1N 0xFFFFFFF
	RJMP _0x20C0011
_0x202002C:
	CALL SUBOPT_0x26
_0x20C0011:
	CALL __LOADLOCR4
	ADIW R28,14
	RET
_put_fat_G101:
	SBIW R28,4
	CALL __SAVELOCR6
	CALL SUBOPT_0x27
	CALL SUBOPT_0x19
	BRLO _0x2020038
	LDD  R26,Y+18
	LDD  R27,Y+18+1
	ADIW R26,30
	CALL __GETD1P
	CALL SUBOPT_0x27
	CALL __CPD21
	BRLO _0x2020037
_0x2020038:
	LDI  R21,LOW(2)
	RJMP _0x202003A
_0x2020037:
	LDD  R26,Y+18
	LDD  R27,Y+18+1
	ADIW R26,34
	CALL __GETD1P
	__PUTD1S 6
	LDD  R26,Y+18
	LDD  R27,Y+18+1
	CALL SUBOPT_0x1C
	BREQ PC+3
	JMP _0x202003E
	__GETWRS 16,17,14
	MOVW R30,R16
	LSR  R31
	ROR  R30
	__ADDWRR 16,17,30,31
	CALL SUBOPT_0x28
	BREQ _0x202003F
	RJMP _0x202003D
_0x202003F:
	CALL SUBOPT_0x29
	BREQ _0x2020040
	MOVW R26,R18
	LD   R30,X
	ANDI R30,LOW(0xF)
	MOV  R26,R30
	LDD  R30,Y+10
	LDI  R31,0
	CALL __LSLW4
	OR   R30,R26
	RJMP _0x2020041
_0x2020040:
	LDD  R30,Y+10
_0x2020041:
	MOVW R26,R18
	ST   X,R30
	__ADDWRN 16,17,1
	LDD  R26,Y+18
	LDD  R27,Y+18+1
	ADIW R26,4
	LDI  R30,LOW(1)
	ST   X,R30
	CALL SUBOPT_0x28
	BREQ _0x2020043
	RJMP _0x202003D
_0x2020043:
	CALL SUBOPT_0x29
	BREQ _0x2020044
	CALL SUBOPT_0x2A
	LDI  R30,LOW(4)
	CALL __LSRD12
	CLR  R31
	CLR  R22
	CLR  R23
	RJMP _0x2020045
_0x2020044:
	MOVW R26,R18
	LD   R30,X
	ANDI R30,LOW(0xF0)
	MOV  R1,R30
	CALL SUBOPT_0x2A
	LDI  R30,LOW(8)
	CALL __LSRD12
	CLR  R31
	CLR  R22
	CLR  R23
	ANDI R30,LOW(0xF)
	OR   R30,R1
_0x2020045:
	MOVW R26,R18
	ST   X,R30
	RJMP _0x202003D
_0x202003E:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x2020047
	CALL SUBOPT_0x2B
	CALL SUBOPT_0x21
	CALL SUBOPT_0x2C
	BRNE _0x202003D
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	LDI  R30,LOW(2)
	CALL SUBOPT_0x2D
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	STD  Z+0,R26
	STD  Z+1,R27
	RJMP _0x202003D
_0x2020047:
	CPI  R30,LOW(0x3)
	LDI  R26,HIGH(0x3)
	CPC  R31,R26
	BRNE _0x202004B
	CALL SUBOPT_0x2B
	CALL SUBOPT_0x25
	CALL SUBOPT_0x2C
	BRNE _0x202003D
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	LDI  R30,LOW(4)
	CALL SUBOPT_0x2D
	CALL SUBOPT_0x2A
	CALL __PUTDZ20
	RJMP _0x202003D
_0x202004B:
	LDI  R21,LOW(2)
_0x202003D:
	LDD  R26,Y+18
	LDD  R27,Y+18+1
	ADIW R26,4
	LDI  R30,LOW(1)
	ST   X,R30
_0x202003A:
	MOV  R30,R21
	CALL __LOADLOCR6
	ADIW R28,20
	RET
_remove_chain_G101:
	SBIW R28,4
	ST   -Y,R17
	CALL SUBOPT_0x2E
	CALL SUBOPT_0x19
	BRLO _0x202004D
	CALL SUBOPT_0x2F
	BRLO _0x202004C
_0x202004D:
	LDI  R17,LOW(2)
	RJMP _0x202004F
_0x202004C:
	LDI  R17,LOW(0)
_0x2020050:
	CALL SUBOPT_0x2F
	BRSH _0x2020052
	CALL SUBOPT_0x30
	RCALL _get_fat_G101
	__PUTD1S 1
	CALL __CPD10
	BREQ _0x2020052
	CALL SUBOPT_0xC
	CALL SUBOPT_0x31
	BRNE _0x2020054
	LDI  R17,LOW(2)
	RJMP _0x2020052
_0x2020054:
	CALL SUBOPT_0xC
	CALL SUBOPT_0x32
	BRNE _0x2020055
	LDI  R17,LOW(1)
	RJMP _0x2020052
_0x2020055:
	CALL SUBOPT_0x30
	CALL SUBOPT_0x33
	CALL SUBOPT_0x34
	MOV  R17,R30
	CPI  R17,0
	BRNE _0x2020052
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	CALL SUBOPT_0x35
	BREQ _0x2020057
	LDD  R26,Y+9
	LDD  R27,Y+9+1
	CALL SUBOPT_0x36
	LDD  R26,Y+9
	LDD  R27,Y+9+1
	ADIW R26,9
	LDI  R30,LOW(1)
	ST   X,R30
_0x2020057:
	__GETD1S 1
	__PUTD1S 5
	RJMP _0x2020050
_0x2020052:
_0x202004F:
	MOV  R30,R17
	LDD  R17,Y+0
	ADIW R28,11
	RET
_create_chain_G101:
	SBIW R28,16
	LDD  R26,Y+20
	LDD  R27,Y+20+1
	ADIW R26,30
	CALL SUBOPT_0x4
	CALL SUBOPT_0x37
	CALL __CPD10
	BRNE _0x2020058
	LDD  R26,Y+20
	LDD  R27,Y+20+1
	ADIW R26,10
	CALL SUBOPT_0x1B
	__GETD2S 4
	CALL __CPD02
	BREQ _0x202005A
	CALL SUBOPT_0x38
	__GETD2S 4
	CALL __CPD21
	BRLO _0x2020059
_0x202005A:
	CALL SUBOPT_0x1A
	CALL SUBOPT_0x39
_0x2020059:
	RJMP _0x202005C
_0x2020058:
	CALL SUBOPT_0x3A
	CALL SUBOPT_0x3B
	CALL SUBOPT_0x3C
	CALL SUBOPT_0x3D
	CALL SUBOPT_0x19
	BRSH _0x202005D
	CALL SUBOPT_0x1A
	RJMP _0x20C0010
_0x202005D:
	CALL SUBOPT_0x38
	CALL SUBOPT_0x3D
	CALL __CPD21
	BRSH _0x202005E
	CALL SUBOPT_0x3E
	RJMP _0x20C0010
_0x202005E:
	CALL SUBOPT_0x37
	CALL SUBOPT_0x39
_0x202005C:
	CALL SUBOPT_0x5
	CALL SUBOPT_0x3F
_0x2020060:
	CALL SUBOPT_0x1F
	__SUBD1N -1
	CALL SUBOPT_0x3F
	CALL SUBOPT_0x38
	CALL SUBOPT_0x18
	CALL __CPD21
	BRLO _0x2020062
	__GETD1N 0x2
	CALL SUBOPT_0x3F
	CALL SUBOPT_0x40
	BRSH _0x2020063
	CALL SUBOPT_0x33
	RJMP _0x20C0010
_0x2020063:
_0x2020062:
	CALL SUBOPT_0x3A
	CALL SUBOPT_0x41
	CALL SUBOPT_0x3C
	CALL SUBOPT_0x42
	BREQ _0x2020061
	CALL SUBOPT_0x3D
	CALL SUBOPT_0x32
	BREQ _0x2020066
	CALL SUBOPT_0x3D
	CALL SUBOPT_0x31
	BRNE _0x2020065
_0x2020066:
	CALL SUBOPT_0x3E
	RJMP _0x20C0010
_0x2020065:
	CALL SUBOPT_0x40
	BRNE _0x2020068
	CALL SUBOPT_0x33
	RJMP _0x20C0010
_0x2020068:
	RJMP _0x2020060
_0x2020061:
	CALL SUBOPT_0x3A
	CALL SUBOPT_0x41
	__GETD1N 0xFFFFFFF
	CALL SUBOPT_0x34
	CPI  R30,0
	BREQ _0x2020069
	CALL SUBOPT_0x26
	RJMP _0x20C0010
_0x2020069:
	CALL SUBOPT_0x37
	CALL __CPD10
	BREQ _0x202006A
	CALL SUBOPT_0x3A
	CALL SUBOPT_0x3B
	__GETD1S 14
	CALL SUBOPT_0x34
	CPI  R30,0
	BREQ _0x202006B
	CALL SUBOPT_0x26
	RJMP _0x20C0010
_0x202006B:
_0x202006A:
	CALL SUBOPT_0x1F
	__PUTD1SNS 20,10
	LDD  R30,Y+20
	LDD  R31,Y+20+1
	CALL SUBOPT_0x35
	BREQ _0x202006C
	LDD  R26,Y+20
	LDD  R27,Y+20+1
	ADIW R26,14
	CALL __GETD1P_INC
	SBIW R30,1
	SBCI R22,0
	SBCI R23,0
	CALL __PUTDP1_DEC
	LDD  R26,Y+20
	LDD  R27,Y+20+1
	ADIW R26,9
	LDI  R30,LOW(1)
	ST   X,R30
_0x202006C:
	CALL SUBOPT_0x1F
_0x20C0010:
	ADIW R28,22
	RET
_clust2sect_G101:
	CALL SUBOPT_0x38
	__SUBD1N 2
	CALL __PUTD1S0
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	__GETD2Z 30
	__GETD1N 0x2
	CALL SUBOPT_0x43
	CALL SUBOPT_0x6
	CALL __CPD21
	BRLO _0x202006D
	CALL SUBOPT_0x33
	RJMP _0x20C000A
_0x202006D:
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	ADIW R26,2
	CALL SUBOPT_0x44
	CALL SUBOPT_0x6
	CALL __CWD1
	CALL __MULD12U
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	ADIW R26,42
	CALL __GETD1P
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL __ADDD12
	RJMP _0x20C000A
_dir_seek_G101:
	SBIW R28,4
	ST   -Y,R17
	ST   -Y,R16
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	__PUTW1SNS 8,4
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	ADIW R26,6
	CALL SUBOPT_0x45
	CALL SUBOPT_0x46
	CALL SUBOPT_0x31
	BREQ _0x202006F
	CALL SUBOPT_0x47
	CALL SUBOPT_0x48
	BRLO _0x202006E
_0x202006F:
	LDI  R30,LOW(2)
	RJMP _0x20C000E
_0x202006E:
	CALL SUBOPT_0x49
	BRNE _0x2020072
	CALL SUBOPT_0x47
	LD   R26,Z
	CPI  R26,LOW(0x3)
	BREQ _0x2020073
_0x2020072:
	RJMP _0x2020071
_0x2020073:
	CALL SUBOPT_0x47
	ADIW R30,38
	MOVW R26,R30
	CALL SUBOPT_0x45
_0x2020071:
	CALL SUBOPT_0x49
	BRNE _0x2020074
	CALL SUBOPT_0x4A
	ADIW R30,7
	MOVW R26,R30
	CALL __GETW1P
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	CP   R26,R30
	CPC  R27,R31
	BRLO _0x2020075
	LDI  R30,LOW(2)
	RJMP _0x20C000E
_0x2020075:
	CALL SUBOPT_0x47
	ADIW R30,38
	MOVW R26,R30
	CALL __GETD1P
	RJMP _0x202022A
_0x2020074:
	CALL SUBOPT_0x47
	LDD  R30,Z+2
	LDI  R26,LOW(16)
	MULS R30,R26
	MOVW R30,R0
	MOVW R16,R30
_0x2020077:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	CP   R26,R16
	CPC  R27,R17
	BRLO _0x2020079
	CALL SUBOPT_0x47
	CALL SUBOPT_0xD
	CALL __PUTPARD1
	CALL SUBOPT_0x4B
	CALL SUBOPT_0x32
	BRNE _0x202007A
	LDI  R30,LOW(1)
	RJMP _0x20C000E
_0x202007A:
	CALL SUBOPT_0x46
	CALL SUBOPT_0x19
	BRLO _0x202007C
	CALL SUBOPT_0x47
	CALL SUBOPT_0x48
	BRLO _0x202007B
_0x202007C:
	LDI  R30,LOW(2)
	RJMP _0x20C000E
_0x202007B:
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	SUB  R30,R16
	SBC  R31,R17
	STD  Y+6,R30
	STD  Y+6+1,R31
	RJMP _0x2020077
_0x2020079:
	CALL SUBOPT_0x4A
	CALL SUBOPT_0xD
	CALL SUBOPT_0x4C
_0x202022A:
	MOVW R26,R30
	MOVW R24,R22
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	CALL __LSRW4
	CALL SUBOPT_0x4D
	__PUTD1SNS 8,14
	CALL SUBOPT_0x47
	ADIW R30,50
	MOVW R26,R30
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	CALL SUBOPT_0x4E
	__PUTW1SNS 8,18
	LDI  R30,LOW(0)
_0x20C000E:
	LDD  R17,Y+1
	LDD  R16,Y+0
_0x20C000F:
	ADIW R28,10
	RET
_dir_next_G101:
	SBIW R28,4
	ST   -Y,R17
	ST   -Y,R16
	LDD  R26,Y+7
	LDD  R27,Y+7+1
	ADIW R26,4
	CALL __GETW1P
	ADIW R30,1
	MOVW R16,R30
	MOV  R0,R16
	OR   R0,R17
	BREQ _0x202007F
	LDD  R26,Y+7
	LDD  R27,Y+7+1
	ADIW R26,14
	CALL SUBOPT_0x4F
	BRNE _0x202007E
_0x202007F:
	LDI  R30,LOW(4)
	RJMP _0x20C000D
_0x202007E:
	MOVW R30,R16
	ANDI R30,LOW(0xF)
	BREQ PC+3
	JMP _0x2020081
	LDD  R26,Y+7
	LDD  R27,Y+7+1
	CALL SUBOPT_0x36
	LDD  R26,Y+7
	LDD  R27,Y+7+1
	ADIW R26,10
	CALL SUBOPT_0x4F
	BRNE _0x2020082
	CALL SUBOPT_0x50
	ADIW R30,7
	MOVW R26,R30
	CALL __GETW1P
	CP   R16,R30
	CPC  R17,R31
	BRLO _0x2020083
	LDI  R30,LOW(4)
	RJMP _0x20C000D
_0x2020083:
	RJMP _0x2020084
_0x2020082:
	MOVW R30,R16
	CALL __LSRW4
	MOVW R0,R30
	CALL SUBOPT_0x50
	LDD  R30,Z+2
	LDI  R31,0
	SBIW R30,1
	AND  R30,R0
	AND  R31,R1
	SBIW R30,0
	BREQ PC+3
	JMP _0x2020085
	CALL SUBOPT_0x50
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	CALL SUBOPT_0x51
	CALL SUBOPT_0x4B
	CALL SUBOPT_0x19
	BRSH _0x2020086
	LDI  R30,LOW(2)
	RJMP _0x20C000D
_0x2020086:
	CALL SUBOPT_0x46
	CALL SUBOPT_0x32
	BRNE _0x2020087
	LDI  R30,LOW(1)
	RJMP _0x20C000D
_0x2020087:
	CALL SUBOPT_0x50
	CALL SUBOPT_0x48
	BRSH PC+3
	JMP _0x2020088
	SBIW R28,1
	LDD  R30,Y+7
	CPI  R30,0
	BRNE _0x2020089
	LDI  R30,LOW(4)
	ADIW R28,1
	RJMP _0x20C000D
_0x2020089:
	CALL SUBOPT_0x47
	CALL SUBOPT_0x52
	CALL SUBOPT_0x51
	RCALL _create_chain_G101
	__PUTD1S 3
	CALL SUBOPT_0x9
	CALL __CPD10
	BRNE _0x202008A
	LDI  R30,LOW(7)
	ADIW R28,1
	RJMP _0x20C000D
_0x202008A:
	__GETD2S 3
	CALL SUBOPT_0x31
	BRNE _0x202008B
	LDI  R30,LOW(2)
	ADIW R28,1
	RJMP _0x20C000D
_0x202008B:
	__GETD2S 3
	CALL SUBOPT_0x32
	BRNE _0x202008C
	LDI  R30,LOW(1)
	ADIW R28,1
	RJMP _0x20C000D
_0x202008C:
	CALL SUBOPT_0x47
	CALL SUBOPT_0x10
	CPI  R30,0
	BREQ _0x202008D
	LDI  R30,LOW(1)
	ADIW R28,1
	RJMP _0x20C000D
_0x202008D:
	CALL SUBOPT_0x47
	CALL SUBOPT_0x12
	CALL SUBOPT_0x47
	MOVW R26,R30
	ADIW R30,46
	PUSH R31
	PUSH R30
	MOVW R30,R26
	ST   -Y,R31
	ST   -Y,R30
	__GETD1S 5
	CALL SUBOPT_0x4C
	POP  R26
	POP  R27
	CALL __PUTDP1
	LDI  R30,LOW(0)
	ST   Y,R30
_0x202008F:
	CALL SUBOPT_0x47
	LDD  R30,Z+2
	LD   R26,Y
	CP   R26,R30
	BRSH _0x2020090
	CALL SUBOPT_0x47
	ADIW R30,4
	LDI  R26,LOW(1)
	STD  Z+0,R26
	CALL SUBOPT_0x47
	CALL SUBOPT_0x10
	CPI  R30,0
	BREQ _0x2020091
	LDI  R30,LOW(1)
	ADIW R28,1
	RJMP _0x20C000D
_0x2020091:
	CALL SUBOPT_0x47
	ADIW R30,46
	MOVW R26,R30
	CALL __GETD1P_INC
	__SUBD1N -1
	CALL __PUTDP1_DEC
	SBIW R30,1
	SBCI R22,0
	SBCI R23,0
	LD   R30,Y
	SUBI R30,-LOW(1)
	ST   Y,R30
	RJMP _0x202008F
_0x2020090:
	CALL SUBOPT_0x47
	ADIW R30,46
	PUSH R31
	PUSH R30
	MOVW R26,R30
	CALL __GETD1P
	MOVW R26,R30
	MOVW R24,R22
	LD   R30,Y
	CALL SUBOPT_0x3
	CALL SUBOPT_0x43
	POP  R26
	POP  R27
	CALL __PUTDP1
	ADIW R28,1
_0x2020088:
	__GETD1S 2
	__PUTD1SNS 7,10
	CALL SUBOPT_0x50
	CALL SUBOPT_0xD
	CALL SUBOPT_0x4C
	__PUTD1SNS 7,14
_0x2020085:
_0x2020084:
_0x2020081:
	MOVW R30,R16
	__PUTW1SNS 7,4
	CALL SUBOPT_0x50
	ADIW R30,50
	MOVW R26,R30
	MOVW R30,R16
	CALL SUBOPT_0x4E
	__PUTW1SNS 7,18
	LDI  R30,LOW(0)
_0x20C000D:
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,9
	RET
_dir_find_G101:
	CALL SUBOPT_0x53
	RCALL _dir_seek_G101
	MOV  R17,R30
	CPI  R17,0
	BREQ _0x2020092
	MOV  R30,R17
	CALL __LOADLOCR4
	RJMP _0x20C000A
_0x2020092:
_0x2020094:
	CALL SUBOPT_0x54
	BRNE _0x2020095
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	ADIW R26,18
	LD   R18,X+
	LD   R19,X
	MOVW R26,R18
	LD   R16,X
	CPI  R16,0
	BRNE _0x2020097
	LDI  R17,LOW(4)
	RJMP _0x2020095
_0x2020097:
	MOVW R30,R18
	LDD  R30,Z+11
	ANDI R30,LOW(0x8)
	BRNE _0x2020099
	CALL SUBOPT_0x55
	RCALL _mem_cmp_G101
	SBIW R30,0
	BREQ _0x202009A
_0x2020099:
	RJMP _0x2020098
_0x202009A:
	RJMP _0x2020095
_0x2020098:
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _dir_next_G101
	MOV  R17,R30
	CPI  R17,0
	BREQ _0x2020094
_0x2020095:
	MOV  R30,R17
	CALL __LOADLOCR4
	RJMP _0x20C000A
_dir_register_G101:
	CALL SUBOPT_0x53
	RCALL _dir_seek_G101
	MOV  R17,R30
	CPI  R17,0
	BRNE _0x20200A7
_0x20200A9:
	CALL SUBOPT_0x54
	BRNE _0x20200AA
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	LDD  R26,Z+18
	LDD  R27,Z+19
	LD   R16,X
	CPI  R16,229
	BREQ _0x20200AD
	CPI  R16,0
	BRNE _0x20200AC
_0x20200AD:
	RJMP _0x20200AA
_0x20200AC:
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	RCALL _dir_next_G101
	MOV  R17,R30
	CPI  R17,0
	BREQ _0x20200A9
_0x20200AA:
_0x20200A7:
	CPI  R17,0
	BRNE _0x20200AF
	CALL SUBOPT_0x54
	BRNE _0x20200B0
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	ADIW R26,18
	LD   R18,X+
	LD   R19,X
	ST   -Y,R19
	ST   -Y,R18
	CALL SUBOPT_0x17
	LDI  R30,LOW(32)
	LDI  R31,HIGH(32)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _mem_set_G101
	CALL SUBOPT_0x55
	RCALL _mem_cpy_G101
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	ADIW R26,20
	CALL __GETW1P
	LDD  R30,Z+11
	ANDI R30,LOW(0x18)
	__PUTB1RNS 18,12
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	CALL __GETW1P
	ADIW R30,4
	LDI  R26,LOW(1)
	STD  Z+0,R26
_0x20200B0:
_0x20200AF:
	MOV  R30,R17
	CALL __LOADLOCR4
	RJMP _0x20C000A
_create_name_G101:
	SBIW R28,8
	CALL __SAVELOCR6
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,20
	LD   R20,X+
	LD   R21,X
	ST   -Y,R21
	ST   -Y,R20
	LDI  R30,LOW(32)
	LDI  R31,HIGH(32)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(11)
	LDI  R31,HIGH(11)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _mem_set_G101
	LDI  R30,LOW(0)
	MOV  R17,R30
	LDI  R31,0
	STD  Y+8,R30
	STD  Y+8+1,R31
	STD  Y+10,R30
	STD  Y+10+1,R31
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	STD  Y+12,R30
	STD  Y+12+1,R31
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	CALL __GETW1P
	STD  Y+6,R30
	STD  Y+6+1,R31
	CALL SUBOPT_0x56
	ADD  R26,R30
	ADC  R27,R31
	LD   R26,X
	CPI  R26,LOW(0x2E)
	BRNE _0x20200B3
_0x20200B5:
	CALL SUBOPT_0x57
	CPI  R16,46
	BRNE _0x20200B8
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	SBIW R26,3
	BRLT _0x20200B7
_0x20200B8:
	RJMP _0x20200B6
_0x20200B7:
	CALL SUBOPT_0x58
	RJMP _0x20200B5
_0x20200B6:
	CPI  R16,47
	BREQ _0x20200BB
	CPI  R16,92
	BREQ _0x20200BB
	CPI  R16,32
	BRSH _0x20200BC
_0x20200BB:
	RJMP _0x20200BA
_0x20200BC:
	LDI  R30,LOW(6)
	RJMP _0x20C000B
_0x20200BA:
	CALL SUBOPT_0x56
	CALL SUBOPT_0x59
	BRSH _0x20200BD
	LDI  R30,LOW(36)
	RJMP _0x20200BE
_0x20200BD:
	LDI  R30,LOW(32)
_0x20200BE:
	__PUTB1RNS 20,11
	RJMP _0x20C000C
_0x20200B3:
_0x20200C1:
	CALL SUBOPT_0x57
	CPI  R16,32
	BRLO _0x20200C4
	CPI  R16,47
	BREQ _0x20200C4
	CPI  R16,92
	BRNE _0x20200C3
_0x20200C4:
	RJMP _0x20200C2
_0x20200C3:
	CPI  R16,46
	BREQ _0x20200C7
	LDD  R30,Y+12
	LDD  R31,Y+12+1
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	CP   R26,R30
	CPC  R27,R31
	BRLT _0x20200C6
_0x20200C7:
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	SBIW R26,8
	BRNE _0x20200CA
	CPI  R16,46
	BREQ _0x20200C9
_0x20200CA:
	LDI  R30,LOW(6)
	RJMP _0x20C000B
_0x20200C9:
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	STD  Y+8,R30
	STD  Y+8+1,R31
	LDI  R30,LOW(11)
	LDI  R31,HIGH(11)
	STD  Y+12,R30
	STD  Y+12+1,R31
	LSL  R17
	LSL  R17
	RJMP _0x20200C0
_0x20200C6:
	CPI  R16,128
	BRLO _0x20200CC
	ORI  R17,LOW(3)
	LDI  R30,LOW(6)
	RJMP _0x20C000B
_0x20200CC:
	LDI  R30,LOW(_k1*2)
	LDI  R31,HIGH(_k1*2)
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R16
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	RCALL _chk_chrf_G101
	SBIW R30,0
	BREQ _0x20200D2
	LDI  R30,LOW(6)
	RJMP _0x20C000B
_0x20200D2:
	CPI  R16,65
	BRLO _0x20200D4
	CPI  R16,91
	BRLO _0x20200D5
_0x20200D4:
	RJMP _0x20200D3
_0x20200D5:
	ORI  R17,LOW(2)
	RJMP _0x20200D6
_0x20200D3:
	CPI  R16,97
	BRLO _0x20200D8
	CPI  R16,123
	BRLO _0x20200D9
_0x20200D8:
	RJMP _0x20200D7
_0x20200D9:
	ORI  R17,LOW(1)
	MOV  R30,R16
	LDI  R31,0
	SBIW R30,32
	MOV  R16,R30
_0x20200D7:
_0x20200D6:
	CALL SUBOPT_0x58
_0x20200C0:
	RJMP _0x20200C1
_0x20200C2:
	CALL SUBOPT_0x56
	CALL SUBOPT_0x59
	BRSH _0x20200DA
	LDI  R30,LOW(4)
	RJMP _0x20200DB
_0x20200DA:
	LDI  R30,LOW(0)
_0x20200DB:
	MOV  R16,R30
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	SBIW R30,0
	BRNE _0x20200DD
	LDI  R30,LOW(6)
	RJMP _0x20C000B
_0x20200DD:
	MOVW R26,R20
	LD   R26,X
	CPI  R26,LOW(0xE5)
	BRNE _0x20200DE
	MOVW R26,R20
	LDI  R30,LOW(5)
	ST   X,R30
_0x20200DE:
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	SBIW R26,8
	BRNE _0x20200DF
	LSL  R17
	LSL  R17
_0x20200DF:
	MOV  R30,R17
	ANDI R30,LOW(0x3)
	CPI  R30,LOW(0x1)
	BRNE _0x20200E0
	ORI  R16,LOW(16)
_0x20200E0:
	MOV  R30,R17
	ANDI R30,LOW(0xC)
	CPI  R30,LOW(0x4)
	BRNE _0x20200E1
	ORI  R16,LOW(8)
_0x20200E1:
	MOVW R30,R20
	__PUTBZR 16,11
_0x20C000C:
	LDI  R30,LOW(0)
_0x20C000B:
	CALL __LOADLOCR6
	ADIW R28,18
	RET
_follow_path_G101:
	CALL __SAVELOCR4
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	LD   R26,X
	CPI  R26,LOW(0x2F)
	BREQ _0x20200F8
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	LD   R26,X
	CPI  R26,LOW(0x5C)
	BRNE _0x20200F7
_0x20200F8:
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	ADIW R30,1
	STD  Y+4,R30
	STD  Y+4+1,R31
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,6
	CALL SUBOPT_0x5A
	RJMP _0x20200FA
_0x20200F7:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	CALL __GETW1P
	ADIW R30,22
	MOVW R26,R30
	CALL __GETD1P
	CALL SUBOPT_0x5B
_0x20200FA:
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	LD   R26,X
	CLR  R27
	SBIW R26,32
	BRSH _0x20200FB
	CALL SUBOPT_0x5C
	CALL SUBOPT_0x17
	RCALL _dir_seek_G101
	MOV  R17,R30
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,18
	CALL SUBOPT_0x5D
	RJMP _0x20200FC
_0x20200FB:
_0x20200FE:
	CALL SUBOPT_0x5C
	MOVW R30,R28
	ADIW R30,6
	ST   -Y,R31
	ST   -Y,R30
	RCALL _create_name_G101
	MOV  R17,R30
	CPI  R17,0
	BRNE _0x20200FF
	CALL SUBOPT_0x5C
	RCALL _dir_find_G101
	MOV  R17,R30
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,20
	CALL __GETW1P
	LDD  R30,Z+11
	ANDI R30,LOW(0x4)
	MOV  R16,R30
	CPI  R17,0
	BREQ _0x2020101
	CPI  R17,4
	BRNE _0x2020103
	CPI  R16,0
	BREQ _0x2020104
_0x2020103:
	RJMP _0x2020102
_0x2020104:
	LDI  R17,LOW(5)
_0x2020102:
	RJMP _0x20200FF
_0x2020101:
	CPI  R16,0
	BRNE _0x20200FF
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,18
	LD   R18,X+
	LD   R19,X
	MOVW R30,R18
	LDD  R30,Z+11
	ANDI R30,LOW(0x10)
	BRNE _0x2020106
	LDI  R17,LOW(5)
	RJMP _0x20200FF
_0x2020106:
	CALL SUBOPT_0x5E
	CALL __LSLD16
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	CALL SUBOPT_0x5F
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL SUBOPT_0x60
	CALL SUBOPT_0x5B
	RJMP _0x20200FE
_0x20200FF:
_0x20200FC:
	MOV  R30,R17
	CALL __LOADLOCR4
	ADIW R28,8
	RET
_check_fs_G101:

	.DSEG

	.CSEG
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	LDD  R26,Z+1
	ST   -Y,R26
	LDD  R30,Y+5
	LDD  R31,Y+5+1
	ADIW R30,50
	ST   -Y,R31
	ST   -Y,R30
	CALL SUBOPT_0x9
	CALL SUBOPT_0x61
	BREQ _0x2020108
	LDI  R30,LOW(3)
	RJMP _0x20C000A
_0x2020108:
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	CALL SUBOPT_0x62
	BREQ _0x2020109
	LDI  R30,LOW(2)
	RJMP _0x20C000A
_0x2020109:
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	SUBI R30,LOW(-104)
	SBCI R31,HIGH(-104)
	CALL SUBOPT_0x63
	BRNE _0x202010A
	LDI  R30,LOW(0)
	RJMP _0x20C000A
_0x202010A:
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	ADIW R30,50
	SUBI R30,LOW(-82)
	SBCI R31,HIGH(-82)
	CALL SUBOPT_0x63
	BRNE _0x202010C
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	SUBI R30,LOW(-90)
	SBCI R31,HIGH(-90)
	LD   R30,Z
	ANDI R30,LOW(0x80)
	BREQ _0x202010D
_0x202010C:
	RJMP _0x202010B
_0x202010D:
	LDI  R30,LOW(0)
	RJMP _0x20C000A
_0x202010B:
	LDI  R30,LOW(1)
_0x20C000A:
	ADIW R28,6
	RET
_auto_mount_G101:
	SBIW R28,21
	CALL __SAVELOCR6
	LDD  R26,Y+30
	LDD  R27,Y+30+1
	CALL __GETW1P
	STD  Y+8,R30
	STD  Y+8+1,R31
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	CALL SUBOPT_0x44
	SBIW R30,48
	MOVW R20,R30
	__CPWRN 20,21,10
	BRSH _0x202010F
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	ADIW R26,1
	LD   R26,X
	CPI  R26,LOW(0x3A)
	BREQ _0x2020110
_0x202010F:
	RJMP _0x202010E
_0x2020110:
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	ADIW R30,2
	STD  Y+8,R30
	STD  Y+8+1,R31
	LDD  R26,Y+30
	LDD  R27,Y+30+1
	ST   X+,R30
	ST   X,R31
	RJMP _0x2020111
_0x202010E:
	LDS  R20,_Drive_G101
	CLR  R21
_0x2020111:
	__CPWRN 20,21,1
	BRLO _0x2020112
	LDI  R30,LOW(11)
	RJMP _0x20C0009
_0x2020112:
	MOVW R30,R20
	LDI  R26,LOW(_FatFs_G101)
	LDI  R27,HIGH(_FatFs_G101)
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDD  R26,Y+28
	LDD  R27,Y+28+1
	ST   X+,R30
	ST   X,R31
	SBIW R30,0
	BRNE _0x2020113
	LDI  R30,LOW(12)
	RJMP _0x20C0009
_0x2020113:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R30,X
	CPI  R30,0
	BREQ _0x2020114
	CALL SUBOPT_0x64
	CALL _disk_status
	STD  Y+26,R30
	ANDI R30,LOW(0x1)
	BRNE _0x2020115
	LDD  R30,Y+27
	CPI  R30,0
	BREQ _0x2020117
	LDD  R30,Y+26
	ANDI R30,LOW(0x4)
	BRNE _0x2020118
_0x2020117:
	RJMP _0x2020116
_0x2020118:
	LDI  R30,LOW(10)
	RJMP _0x20C0009
_0x2020116:
	LDI  R30,LOW(0)
	RJMP _0x20C0009
_0x2020115:
_0x2020114:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LDI  R30,LOW(0)
	ST   X,R30
	MOV  R30,R20
	__PUTB1SNS 6,1
	CALL SUBOPT_0x64
	CALL _disk_initialize
	STD  Y+26,R30
	ANDI R30,LOW(0x1)
	BREQ _0x2020119
	LDI  R30,LOW(3)
	RJMP _0x20C0009
_0x2020119:
	LDD  R30,Y+27
	CPI  R30,0
	BREQ _0x202011B
	LDD  R30,Y+26
	ANDI R30,LOW(0x4)
	BRNE _0x202011C
_0x202011B:
	RJMP _0x202011A
_0x202011C:
	LDI  R30,LOW(10)
	RJMP _0x20C0009
_0x202011A:
	CALL SUBOPT_0x5C
	CALL SUBOPT_0x33
	__PUTD1S 24
	CALL __PUTPARD1
	RCALL _check_fs_G101
	MOV  R16,R30
	CPI  R16,1
	BRNE _0x202011D
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ADIW R30,50
	SUBI R30,LOW(-446)
	SBCI R31,HIGH(-446)
	MOVW R18,R30
	MOVW R30,R18
	LDD  R30,Z+4
	CPI  R30,0
	BREQ _0x202011E
	MOVW R26,R18
	ADIW R26,8
	CALL __GETD1P
	__PUTD1S 22
	CALL SUBOPT_0x5C
	__GETD1S 24
	CALL __PUTPARD1
	RCALL _check_fs_G101
	MOV  R16,R30
_0x202011E:
_0x202011D:
	CPI  R16,3
	BRNE _0x202011F
	LDI  R30,LOW(1)
	RJMP _0x20C0009
_0x202011F:
	CPI  R16,0
	BRNE _0x2020121
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,61
	CALL __GETW1P
	CPI  R30,LOW(0x200)
	LDI  R26,HIGH(0x200)
	CPC  R31,R26
	BREQ _0x2020120
_0x2020121:
	LDI  R30,LOW(13)
	RJMP _0x20C0009
_0x2020120:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SUBI R26,LOW(-72)
	SBCI R27,HIGH(-72)
	CALL SUBOPT_0x24
	CALL SUBOPT_0x65
	CALL SUBOPT_0x66
	CALL __CPD10
	BRNE _0x2020123
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SUBI R26,LOW(-86)
	SBCI R27,HIGH(-86)
	CALL __GETD1P
	CALL SUBOPT_0x65
_0x2020123:
	CALL SUBOPT_0x66
	__PUTD1SNS 6,26
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	SUBI R30,LOW(-66)
	SBCI R31,HIGH(-66)
	LD   R30,Z
	__PUTB1SNS 6,3
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,3
	CALL SUBOPT_0x44
	__GETD2S 18
	CALL __CWD1
	CALL __MULD12U
	CALL SUBOPT_0x65
	CALL SUBOPT_0x67
	CALL SUBOPT_0x68
	__PUTD1SNS 6,34
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	LDD  R30,Z+63
	__PUTB1SNS 6,2
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SUBI R26,LOW(-67)
	SBCI R27,HIGH(-67)
	CALL __GETW1P
	__PUTW1SNS 6,7
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SUBI R26,LOW(-69)
	SBCI R27,HIGH(-69)
	CALL SUBOPT_0x24
	__PUTD1S 14
	CALL __CPD10
	BRNE _0x2020124
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SUBI R26,LOW(-82)
	SBCI R27,HIGH(-82)
	CALL __GETD1P
	__PUTD1S 14
_0x2020124:
	CALL SUBOPT_0x67
	CALL SUBOPT_0x27
	CLR  R22
	CLR  R23
	CALL SUBOPT_0x43
	__GETD2S 18
	CALL __SUBD12
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	CALL SUBOPT_0x69
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CLR  R22
	CLR  R23
	CALL SUBOPT_0x43
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,2
	CALL SUBOPT_0x44
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL __CWD1
	CALL __DIVD21U
	__ADDD1N 2
	__PUTD1S 10
	__PUTD1SNS 6,30
	LDI  R16,LOW(1)
	CALL SUBOPT_0x2A
	__CPD2N 0xFF7
	BRLO _0x2020125
	LDI  R16,LOW(2)
_0x2020125:
	CALL SUBOPT_0x2A
	__CPD2N 0xFFF7
	BRLO _0x2020126
	LDI  R16,LOW(3)
_0x2020126:
	CPI  R16,3
	BRNE _0x2020127
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SUBI R26,LOW(-94)
	SBCI R27,HIGH(-94)
	CALL __GETD1P
	RJMP _0x202022B
_0x2020127:
	CALL SUBOPT_0x6A
_0x202022B:
	__PUTD1SNS 6,38
	CALL SUBOPT_0x6A
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	CALL SUBOPT_0x69
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL SUBOPT_0x4D
	__PUTD1SNS 6,42
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,14
	CALL SUBOPT_0x26
	CALL __PUTDP1
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,4
	LDI  R30,LOW(0)
	ST   X,R30
	CPI  R16,3
	BREQ PC+3
	JMP _0x2020129
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,9
	ST   X,R30
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SUBI R26,LOW(-98)
	SBCI R27,HIGH(-98)
	CALL __GETW1P
	CALL SUBOPT_0x68
	__PUTD1SNS 6,18
	CALL SUBOPT_0x64
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ADIW R30,50
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	CALL SUBOPT_0x15
	CALL SUBOPT_0xF
	BRNE _0x202012B
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	CALL SUBOPT_0x62
	BRNE _0x202012B
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,50
	CALL __GETD1P
	__CPD1N 0x41615252
	BRNE _0x202012B
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ADIW R30,50
	SUBI R30,LOW(-484)
	SBCI R31,HIGH(-484)
	MOVW R26,R30
	CALL __GETD1P
	__CPD1N 0x61417272
	BREQ _0x202012C
_0x202012B:
	RJMP _0x202012A
_0x202012C:
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ADIW R30,50
	SUBI R30,LOW(-492)
	SBCI R31,HIGH(-492)
	MOVW R26,R30
	CALL __GETD1P
	__PUTD1SNS 6,10
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ADIW R30,50
	SUBI R30,LOW(-488)
	SBCI R31,HIGH(-488)
	MOVW R26,R30
	CALL __GETD1P
	__PUTD1SNS 6,14
_0x202012A:
_0x2020129:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ST   X,R16
	CALL SUBOPT_0x11
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADIW R26,22
	CALL SUBOPT_0x5A
	LDI  R26,LOW(_Fsid_G101)
	LDI  R27,HIGH(_Fsid_G101)
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
	__PUTW1SNS 6,5
	LDI  R17,LOW(0)
	MOV  R30,R17
_0x20C0009:
	CALL __LOADLOCR6
	ADIW R28,32
	RET
_validate_G101:
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	SBIW R30,0
	BREQ _0x202012E
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	LD   R30,X
	CPI  R30,0
	BREQ _0x202012E
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	LDD  R26,Z+5
	LDD  R27,Z+6
	LD   R30,Y
	LDD  R31,Y+1
	CP   R30,R26
	CPC  R31,R27
	BREQ _0x202012D
_0x202012E:
	LDI  R30,LOW(9)
	RJMP _0x20C0008
_0x202012D:
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	LDD  R26,Z+1
	ST   -Y,R26
	CALL _disk_status
	ANDI R30,LOW(0x1)
	BREQ _0x2020130
	LDI  R30,LOW(3)
	RJMP _0x20C0008
_0x2020130:
	LDI  R30,LOW(0)
_0x20C0008:
	ADIW R28,4
	RET
_f_mount:
	ST   -Y,R17
	ST   -Y,R16
	LDD  R26,Y+4
	CPI  R26,LOW(0x1)
	BRLO _0x2020131
	LDI  R30,LOW(11)
	RJMP _0x20C0007
_0x2020131:
	CALL SUBOPT_0x6B
	ADD  R26,R30
	ADC  R27,R31
	LD   R16,X+
	LD   R17,X
	MOV  R0,R16
	OR   R0,R17
	BREQ _0x2020132
	MOVW R26,R16
	LDI  R30,LOW(0)
	ST   X,R30
_0x2020132:
	LDD  R30,Y+2
	LDD  R31,Y+2+1
	SBIW R30,0
	BREQ _0x2020133
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	LDI  R30,LOW(0)
	ST   X,R30
_0x2020133:
	CALL SUBOPT_0x6B
	ADD  R30,R26
	ADC  R31,R27
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	STD  Z+0,R26
	STD  Z+1,R27
	LDI  R30,LOW(0)
_0x20C0007:
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,5
	RET
_f_open:
	SBIW R28,34
	CALL __SAVELOCR4
	LDD  R26,Y+41
	LDD  R27,Y+41+1
	CALL SUBOPT_0x5D
	LDD  R30,Y+38
	ANDI R30,LOW(0x1F)
	STD  Y+38,R30
	MOVW R30,R28
	ADIW R30,39
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,18
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+42
	ANDI R30,LOW(0x1E)
	ST   -Y,R30
	RCALL _auto_mount_G101
	MOV  R17,R30
	CPI  R17,0
	BREQ _0x2020134
	MOV  R30,R17
	RJMP _0x20C0006
_0x2020134:
	MOVW R30,R28
	ADIW R30,4
	STD  Y+36,R30
	STD  Y+36+1,R31
	MOVW R30,R28
	ADIW R30,16
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+41
	LDD  R31,Y+41+1
	ST   -Y,R31
	ST   -Y,R30
	RCALL _follow_path_G101
	MOV  R17,R30
	LDD  R30,Y+38
	ANDI R30,LOW(0x1C)
	BRNE PC+3
	JMP _0x2020135
	SBIW R28,8
	CPI  R17,0
	BREQ _0x2020136
	CPI  R17,4
	BRNE _0x2020137
	MOVW R30,R28
	ADIW R30,24
	ST   -Y,R31
	ST   -Y,R30
	RCALL _dir_register_G101
	MOV  R17,R30
_0x2020137:
	CPI  R17,0
	BREQ _0x2020138
	MOV  R30,R17
	ADIW R28,8
	RJMP _0x20C0006
_0x2020138:
	LDD  R30,Y+46
	ORI  R30,8
	STD  Y+46,R30
	__GETWRS 18,19,42
	RJMP _0x2020139
_0x2020136:
	LDD  R30,Y+46
	ANDI R30,LOW(0x4)
	BREQ _0x202013A
	LDI  R30,LOW(8)
	ADIW R28,8
	RJMP _0x20C0006
_0x202013A:
	__GETWRS 18,19,42
	MOV  R0,R18
	OR   R0,R19
	BREQ _0x202013C
	MOVW R30,R18
	LDD  R30,Z+11
	ANDI R30,LOW(0x11)
	BREQ _0x202013B
_0x202013C:
	LDI  R30,LOW(7)
	ADIW R28,8
	RJMP _0x20C0006
_0x202013B:
	LDD  R30,Y+46
	ANDI R30,LOW(0x8)
	BRNE PC+3
	JMP _0x202013E
	CALL SUBOPT_0x5E
	CALL __LSLD16
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	CALL SUBOPT_0x5F
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL SUBOPT_0x60
	CALL __PUTD1S0
	MOVW R30,R18
	ADIW R30,20
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	STD  Z+0,R26
	STD  Z+1,R27
	MOVW R30,R18
	ADIW R30,26
	STD  Z+0,R26
	STD  Z+1,R27
	MOVW R30,R18
	ADIW R30,28
	__GETD2N 0x0
	CALL __PUTDZ20
	LDD  R26,Y+24
	LDD  R27,Y+24+1
	ADIW R26,4
	LDI  R30,LOW(1)
	ST   X,R30
	LDD  R26,Y+24
	LDD  R27,Y+24+1
	ADIW R26,46
	CALL SUBOPT_0x1B
	CALL SUBOPT_0x38
	CALL __CPD10
	BREQ _0x202013F
	LDD  R30,Y+24
	LDD  R31,Y+24+1
	ST   -Y,R31
	ST   -Y,R30
	__GETD1S 2
	CALL __PUTPARD1
	RCALL _remove_chain_G101
	MOV  R17,R30
	CPI  R17,0
	BREQ _0x2020140
	MOV  R30,R17
	ADIW R28,8
	RJMP _0x20C0006
_0x2020140:
	CALL SUBOPT_0x38
	__SUBD1N 1
	__PUTD1SNS 24,10
_0x202013F:
	LDD  R30,Y+24
	LDD  R31,Y+24+1
	ST   -Y,R31
	ST   -Y,R30
	__GETD1S 6
	CALL __PUTPARD1
	CALL _move_window_G101
	MOV  R17,R30
	CPI  R17,0
	BREQ _0x2020141
	MOV  R30,R17
	ADIW R28,8
	RJMP _0x20C0006
_0x2020141:
_0x202013E:
_0x2020139:
	LDD  R30,Y+46
	ANDI R30,LOW(0x8)
	BREQ _0x2020142
	MOVW R30,R18
	ADIW R30,11
	LDI  R26,LOW(0)
	STD  Z+0,R26
	CALL SUBOPT_0x6C
	__PUTD1RNS 18,14
	LDD  R26,Y+24
	LDD  R27,Y+24+1
	ADIW R26,4
	LDI  R30,LOW(1)
	ST   X,R30
	LDD  R30,Y+46
	ORI  R30,0x20
	STD  Y+46,R30
_0x2020142:
	ADIW R28,8
	RJMP _0x2020143
_0x2020135:
	CPI  R17,0
	BREQ _0x2020144
	MOV  R30,R17
	RJMP _0x20C0006
_0x2020144:
	__GETWRS 18,19,34
	MOV  R0,R18
	OR   R0,R19
	BREQ _0x2020146
	MOVW R30,R18
	LDD  R30,Z+11
	ANDI R30,LOW(0x10)
	BREQ _0x2020145
_0x2020146:
	LDI  R30,LOW(4)
	RJMP _0x20C0006
_0x2020145:
	LDD  R30,Y+38
	ANDI R30,LOW(0x2)
	BREQ _0x2020149
	MOVW R30,R18
	LDD  R30,Z+11
	ANDI R30,LOW(0x1)
	BRNE _0x202014A
_0x2020149:
	RJMP _0x2020148
_0x202014A:
	LDI  R30,LOW(7)
	RJMP _0x20C0006
_0x2020148:
_0x2020143:
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,46
	CALL __GETD1P
	__PUTD1SNS 41,26
	LDD  R30,Y+34
	LDD  R31,Y+34+1
	__PUTW1SNS 41,30
	LDD  R30,Y+38
	__PUTB1SNS 41,4
	CALL SUBOPT_0x5E
	CALL __LSLD16
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	CALL SUBOPT_0x5F
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL SUBOPT_0x60
	__PUTD1SNS 41,14
	MOVW R26,R18
	ADIW R26,28
	CALL __GETD1P
	__PUTD1SNS 41,10
	LDD  R26,Y+41
	LDD  R27,Y+41+1
	ADIW R26,6
	CALL SUBOPT_0x5A
	LDD  R26,Y+41
	LDD  R27,Y+41+1
	ADIW R26,5
	LDI  R30,LOW(255)
	ST   X,R30
	LDD  R26,Y+41
	LDD  R27,Y+41+1
	ADIW R26,22
	CALL SUBOPT_0x5A
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	LDD  R26,Y+41
	LDD  R27,Y+41+1
	ST   X+,R30
	ST   X,R31
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	ADIW R26,5
	CALL __GETW1P
	__PUTW1SNS 41,2
	LDI  R30,LOW(0)
_0x20C0006:
	CALL __LOADLOCR4
	ADIW R28,43
	RET
_f_read:
	SBIW R28,14
	CALL __SAVELOCR6
	LDD  R30,Y+24
	LDD  R31,Y+24+1
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDD  R26,Y+20
	LDD  R27,Y+20+1
	CALL SUBOPT_0x5D
	CALL SUBOPT_0x6D
	CALL SUBOPT_0x6E
	CALL SUBOPT_0x6F
	BREQ _0x202014B
	MOV  R30,R17
	RJMP _0x20C0005
_0x202014B:
	LDD  R30,Y+26
	LDD  R31,Y+26+1
	LDD  R26,Z+4
	ANDI R26,LOW(0x80)
	BREQ _0x202014C
	LDI  R30,LOW(2)
	RJMP _0x20C0005
_0x202014C:
	LDD  R30,Y+26
	LDD  R31,Y+26+1
	LDD  R26,Z+4
	ANDI R26,LOW(0x1)
	BRNE _0x202014D
	LDI  R30,LOW(7)
	RJMP _0x20C0005
_0x202014D:
	LDD  R30,Y+26
	LDD  R31,Y+26+1
	__GETD2Z 10
	PUSH R25
	PUSH R24
	PUSH R27
	PUSH R26
	CALL SUBOPT_0x70
	POP  R30
	POP  R31
	POP  R22
	POP  R23
	CALL __SUBD12
	CALL SUBOPT_0x3F
	CALL SUBOPT_0x1F
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CLR  R24
	CLR  R25
	CALL __CPD12
	BRSH _0x202014E
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	STD  Y+22,R30
	STD  Y+22+1,R31
_0x202014E:
_0x2020150:
	LDD  R30,Y+22
	LDD  R31,Y+22+1
	SBIW R30,0
	BRNE PC+3
	JMP _0x2020151
	CALL SUBOPT_0x70
	MOVW R30,R26
	MOVW R22,R24
	ANDI R31,HIGH(0x1FF)
	SBIW R30,0
	BREQ PC+3
	JMP _0x2020152
	LDD  R30,Y+26
	LDD  R31,Y+26+1
	LDD  R0,Z+5
	CALL SUBOPT_0x6D
	LDD  R30,Z+2
	CP   R0,R30
	BRLO _0x2020153
	CALL SUBOPT_0x70
	CALL __CPD02
	BRNE _0x2020154
	LDD  R26,Y+26
	LDD  R27,Y+26+1
	ADIW R26,14
	CALL __GETD1P
	RJMP _0x2020155
_0x2020154:
	CALL SUBOPT_0x6D
	CALL SUBOPT_0x6E
	CALL SUBOPT_0x15
	CALL _get_fat_G101
_0x2020155:
	__PUTD1S 16
	__GETD2S 16
	CALL SUBOPT_0x19
	BRSH _0x2020157
	CALL SUBOPT_0x71
	LDI  R30,LOW(2)
	RJMP _0x20C0005
_0x2020157:
	__GETD2S 16
	CALL SUBOPT_0x32
	BRNE _0x2020158
	CALL SUBOPT_0x71
	LDI  R30,LOW(1)
	RJMP _0x20C0005
_0x2020158:
	CALL SUBOPT_0x37
	__PUTD1SNS 26,18
	LDD  R26,Y+26
	LDD  R27,Y+26+1
	ADIW R26,5
	LDI  R30,LOW(0)
	ST   X,R30
_0x2020153:
	CALL SUBOPT_0x6D
	CALL SUBOPT_0x6E
	CALL SUBOPT_0x15
	CALL _clust2sect_G101
	CALL SUBOPT_0x72
	CALL SUBOPT_0x42
	BRNE _0x2020159
	CALL SUBOPT_0x71
	LDI  R30,LOW(2)
	RJMP _0x20C0005
_0x2020159:
	CALL SUBOPT_0x73
	CALL SUBOPT_0x3D
	CALL __CWD1
	CALL __ADDD12
	CALL SUBOPT_0x72
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL SUBOPT_0x74
	BRNE PC+3
	JMP _0x202015A
	CALL SUBOPT_0x73
	ADD  R30,R20
	ADC  R31,R21
	MOVW R0,R30
	CALL SUBOPT_0x6D
	CALL SUBOPT_0x75
	BRSH _0x202015B
	CALL SUBOPT_0x6D
	LDD  R0,Z+2
	CLR  R1
	CALL SUBOPT_0x73
	MOVW R26,R0
	SUB  R26,R30
	SBC  R27,R31
	MOVW R20,R26
_0x202015B:
	CALL SUBOPT_0x6D
	CALL SUBOPT_0x76
	__GETD1S 15
	CALL __PUTPARD1
	ST   -Y,R20
	CALL _disk_read
	CPI  R30,0
	BREQ _0x202015C
	CALL SUBOPT_0x71
	LDI  R30,LOW(1)
	RJMP _0x20C0005
_0x202015C:
	LDD  R30,Y+26
	LDD  R31,Y+26+1
	LDD  R26,Z+4
	ANDI R26,LOW(0x40)
	BREQ _0x202015E
	CALL SUBOPT_0x77
	CALL SUBOPT_0x78
	BRLO _0x202015F
_0x202015E:
	RJMP _0x202015D
_0x202015F:
	CALL SUBOPT_0x77
	CALL SUBOPT_0x79
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	CLR  R24
	CLR  R25
	ADD  R30,R26
	ADC  R31,R27
	CALL SUBOPT_0x6E
	ADIW R30,32
	CALL SUBOPT_0x7A
_0x202015D:
	LDD  R26,Y+26
	LDD  R27,Y+26+1
	CALL SUBOPT_0x7B
	RJMP _0x202014F
_0x202015A:
	LDD  R30,Y+26
	LDD  R31,Y+26+1
	LDD  R26,Z+4
	ANDI R26,LOW(0x40)
	BREQ _0x2020160
	CALL SUBOPT_0x6D
	CALL SUBOPT_0x7C
	LDD  R30,Y+29
	LDD  R31,Y+29+1
	CALL SUBOPT_0x7D
	CPI  R30,0
	BREQ _0x2020161
	CALL SUBOPT_0x71
	LDI  R30,LOW(1)
	RJMP _0x20C0005
_0x2020161:
	LDD  R26,Y+26
	LDD  R27,Y+26+1
	CALL SUBOPT_0x7E
_0x2020160:
	CALL SUBOPT_0x77
	CALL __CPD12
	BREQ _0x2020162
	CALL SUBOPT_0x6D
	CALL SUBOPT_0x7C
	__GETD1S 15
	CALL SUBOPT_0x61
	BREQ _0x2020163
	CALL SUBOPT_0x71
	LDI  R30,LOW(1)
	RJMP _0x20C0005
_0x2020163:
_0x2020162:
	CALL SUBOPT_0x3E
	__PUTD1SNS 26,22
	LDD  R26,Y+26
	LDD  R27,Y+26+1
	ADIW R26,5
	LD   R30,X
	SUBI R30,-LOW(1)
	ST   X,R30
_0x2020152:
	CALL SUBOPT_0x70
	CALL SUBOPT_0x7F
	CALL SUBOPT_0x80
	MOVW R18,R30
	LDD  R30,Y+22
	LDD  R31,Y+22+1
	CP   R30,R18
	CPC  R31,R19
	BRSH _0x2020164
	__GETWRS 18,19,22
_0x2020164:
	CALL SUBOPT_0x5C
	LDD  R30,Y+28
	LDD  R31,Y+28+1
	ADIW R30,32
	MOVW R0,R30
	LDD  R30,Y+28
	LDD  R31,Y+28+1
	CALL SUBOPT_0x81
	CALL SUBOPT_0x7F
	ADD  R30,R0
	ADC  R31,R1
	CALL SUBOPT_0x82
_0x202014F:
	CALL SUBOPT_0x83
	LDD  R30,Y+26
	LDD  R31,Y+26+1
	CALL SUBOPT_0x84
	MOVW R26,R0
	CALL __PUTDP1
	LDD  R26,Y+20
	LDD  R27,Y+20+1
	CALL SUBOPT_0x85
	LDD  R30,Y+22
	LDD  R31,Y+22+1
	SUB  R30,R18
	SBC  R31,R19
	STD  Y+22,R30
	STD  Y+22+1,R31
	RJMP _0x2020150
_0x2020151:
	LDI  R30,LOW(0)
_0x20C0005:
	CALL __LOADLOCR6
	ADIW R28,28
	RET
_f_write:
	SBIW R28,10
	CALL __SAVELOCR6
	LDD  R30,Y+20
	LDD  R31,Y+20+1
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	CALL SUBOPT_0x5D
	CALL SUBOPT_0x86
	CALL SUBOPT_0x87
	CALL SUBOPT_0x6F
	BREQ _0x2020165
	MOV  R30,R17
	RJMP _0x20C0004
_0x2020165:
	LDD  R30,Y+22
	LDD  R31,Y+22+1
	LDD  R26,Z+4
	ANDI R26,LOW(0x80)
	BREQ _0x2020166
	LDI  R30,LOW(2)
	RJMP _0x20C0004
_0x2020166:
	LDD  R30,Y+22
	LDD  R31,Y+22+1
	LDD  R26,Z+4
	ANDI R26,LOW(0x2)
	BRNE _0x2020167
	LDI  R30,LOW(7)
	RJMP _0x20C0004
_0x2020167:
	LDD  R30,Y+22
	LDD  R31,Y+22+1
	__GETD2Z 10
	LDD  R30,Y+18
	LDD  R31,Y+18+1
	CALL SUBOPT_0x4D
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	CALL SUBOPT_0x88
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL __CPD21
	BRSH _0x2020168
	LDI  R30,LOW(0)
	STD  Y+18,R30
	STD  Y+18+1,R30
_0x2020168:
_0x202016A:
	LDD  R30,Y+18
	LDD  R31,Y+18+1
	SBIW R30,0
	BRNE PC+3
	JMP _0x202016B
	CALL SUBOPT_0x89
	MOVW R30,R26
	MOVW R22,R24
	ANDI R31,HIGH(0x1FF)
	SBIW R30,0
	BREQ PC+3
	JMP _0x202016C
	LDD  R30,Y+22
	LDD  R31,Y+22+1
	LDD  R0,Z+5
	CALL SUBOPT_0x86
	LDD  R30,Z+2
	CP   R0,R30
	BRSH PC+3
	JMP _0x202016D
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	ADIW R26,6
	CALL SUBOPT_0x4F
	BRNE _0x202016E
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	ADIW R26,14
	CALL __GETD1P
	CALL SUBOPT_0x72
	CALL SUBOPT_0x42
	BRNE _0x202016F
	CALL SUBOPT_0x86
	ST   -Y,R31
	ST   -Y,R30
	CALL SUBOPT_0x33
	CALL __PUTPARD1
	CALL _create_chain_G101
	CALL SUBOPT_0x72
	__PUTD1SNS 22,14
_0x202016F:
	RJMP _0x2020170
_0x202016E:
	CALL SUBOPT_0x86
	CALL SUBOPT_0x87
	CALL SUBOPT_0x15
	CALL _create_chain_G101
	CALL SUBOPT_0x72
_0x2020170:
	CALL SUBOPT_0x42
	BRNE _0x2020171
	RJMP _0x202016B
_0x2020171:
	CALL SUBOPT_0x3D
	CALL SUBOPT_0x31
	BRNE _0x2020172
	CALL SUBOPT_0x8A
	LDI  R30,LOW(2)
	RJMP _0x20C0004
_0x2020172:
	CALL SUBOPT_0x3D
	CALL SUBOPT_0x32
	BRNE _0x2020173
	CALL SUBOPT_0x8A
	LDI  R30,LOW(1)
	RJMP _0x20C0004
_0x2020173:
	CALL SUBOPT_0x3E
	__PUTD1SNS 22,18
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	ADIW R26,5
	LDI  R30,LOW(0)
	ST   X,R30
_0x202016D:
	LDD  R30,Y+22
	LDD  R31,Y+22+1
	LDD  R26,Z+4
	ANDI R26,LOW(0x40)
	BREQ _0x2020174
	CALL SUBOPT_0x86
	CALL SUBOPT_0x8B
	LDD  R30,Y+25
	LDD  R31,Y+25+1
	CALL SUBOPT_0x7D
	CPI  R30,0
	BREQ _0x2020175
	CALL SUBOPT_0x8A
	LDI  R30,LOW(1)
	RJMP _0x20C0004
_0x2020175:
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL SUBOPT_0x7E
_0x2020174:
	CALL SUBOPT_0x86
	CALL SUBOPT_0x87
	CALL SUBOPT_0x15
	CALL _clust2sect_G101
	CALL SUBOPT_0x3F
	CALL SUBOPT_0x1F
	CALL __CPD10
	BRNE _0x2020176
	CALL SUBOPT_0x8A
	LDI  R30,LOW(2)
	RJMP _0x20C0004
_0x2020176:
	CALL SUBOPT_0x8C
	CALL SUBOPT_0x18
	CALL __CWD1
	CALL __ADDD12
	CALL SUBOPT_0x3F
	LDD  R26,Y+18
	LDD  R27,Y+18+1
	CALL SUBOPT_0x74
	BRNE PC+3
	JMP _0x2020177
	CALL SUBOPT_0x8C
	ADD  R30,R20
	ADC  R31,R21
	MOVW R0,R30
	CALL SUBOPT_0x86
	CALL SUBOPT_0x75
	BRSH _0x2020178
	CALL SUBOPT_0x86
	LDD  R0,Z+2
	CLR  R1
	CALL SUBOPT_0x8C
	MOVW R26,R0
	SUB  R26,R30
	SBC  R27,R31
	MOVW R20,R26
_0x2020178:
	CALL SUBOPT_0x86
	CALL SUBOPT_0x76
	__GETD1S 11
	CALL __PUTPARD1
	ST   -Y,R20
	CALL _disk_write
	CPI  R30,0
	BREQ _0x2020179
	CALL SUBOPT_0x8A
	LDI  R30,LOW(1)
	RJMP _0x20C0004
_0x2020179:
	CALL SUBOPT_0x8D
	CALL SUBOPT_0x78
	BRSH _0x202017A
	LDD  R30,Y+22
	LDD  R31,Y+22+1
	ADIW R30,32
	CALL SUBOPT_0x87
	__GETD2Z 22
	__GETD1S 10
	CALL SUBOPT_0x79
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	CLR  R24
	CLR  R25
	ADD  R30,R26
	ADC  R31,R27
	CALL SUBOPT_0x7A
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL SUBOPT_0x7E
_0x202017A:
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL SUBOPT_0x7B
	RJMP _0x2020169
_0x2020177:
	CALL SUBOPT_0x8D
	CALL __CPD12
	BREQ _0x202017B
	CALL SUBOPT_0x89
	MOVW R0,R26
	CALL SUBOPT_0x88
	MOVW R26,R0
	CALL __CPD21
	BRSH _0x202017D
	CALL SUBOPT_0x86
	CALL SUBOPT_0x8B
	__GETD1S 11
	CALL SUBOPT_0x61
	BRNE _0x202017E
_0x202017D:
	RJMP _0x202017C
_0x202017E:
	CALL SUBOPT_0x8A
	LDI  R30,LOW(1)
	RJMP _0x20C0004
_0x202017C:
_0x202017B:
	CALL SUBOPT_0x1F
	__PUTD1SNS 22,22
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	ADIW R26,5
	LD   R30,X
	SUBI R30,-LOW(1)
	ST   X,R30
_0x202016C:
	CALL SUBOPT_0x89
	CALL SUBOPT_0x7F
	CALL SUBOPT_0x80
	MOVW R18,R30
	LDD  R30,Y+18
	LDD  R31,Y+18+1
	CP   R30,R18
	CPC  R31,R19
	BRSH _0x202017F
	__GETWRS 18,19,18
_0x202017F:
	LDD  R30,Y+22
	LDD  R31,Y+22+1
	ADIW R30,32
	MOVW R0,R30
	CALL SUBOPT_0x89
	CALL SUBOPT_0x7F
	ADD  R30,R0
	ADC  R31,R1
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	CALL SUBOPT_0x82
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	ADIW R26,4
	LD   R30,X
	ORI  R30,0x40
	ST   X,R30
_0x2020169:
	CALL SUBOPT_0x83
	LDD  R30,Y+22
	LDD  R31,Y+22+1
	CALL SUBOPT_0x84
	MOVW R26,R0
	CALL __PUTDP1
	LDD  R26,Y+16
	LDD  R27,Y+16+1
	CALL SUBOPT_0x85
	LDD  R30,Y+18
	LDD  R31,Y+18+1
	SUB  R30,R18
	SBC  R31,R19
	STD  Y+18,R30
	STD  Y+18+1,R31
	RJMP _0x202016A
_0x202016B:
	CALL SUBOPT_0x89
	MOVW R0,R26
	CALL SUBOPT_0x88
	MOVW R26,R0
	CALL __CPD12
	BRSH _0x2020180
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	ADIW R26,6
	CALL __GETD1P
	__PUTD1SNS 22,10
_0x2020180:
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	ADIW R26,4
	LD   R30,X
	ORI  R30,0x20
	ST   X,R30
	LDI  R30,LOW(0)
_0x20C0004:
	CALL __LOADLOCR6
	ADIW R28,24
	RET
_f_sync:
	SBIW R28,4
	CALL __SAVELOCR4
	CALL SUBOPT_0x47
	CALL SUBOPT_0x52
	CALL SUBOPT_0x6F
	BREQ PC+3
	JMP _0x2020181
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	LDD  R26,Z+4
	ANDI R26,LOW(0x20)
	BRNE PC+3
	JMP _0x2020182
	LDD  R26,Z+4
	ANDI R26,LOW(0x40)
	BREQ _0x2020183
	CALL SUBOPT_0x47
	LDD  R30,Z+1
	ST   -Y,R30
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	ADIW R30,32
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+11
	LDD  R31,Y+11+1
	CALL SUBOPT_0x7D
	CPI  R30,0
	BREQ _0x2020184
	LDI  R30,LOW(1)
	RJMP _0x20C0003
_0x2020184:
	CALL SUBOPT_0x7
	ANDI R30,0xBF
	ST   X,R30
_0x2020183:
	CALL SUBOPT_0x47
	CALL SUBOPT_0x52
	__GETD2Z 26
	CALL __PUTPARD2
	CALL _move_window_G101
	MOV  R17,R30
	CPI  R17,0
	BREQ PC+3
	JMP _0x2020185
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	ADIW R26,30
	LD   R18,X+
	LD   R19,X
	MOVW R26,R18
	ADIW R26,11
	LD   R30,X
	ORI  R30,0x20
	ST   X,R30
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	ADIW R26,10
	CALL __GETD1P
	__PUTD1RNS 18,28
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	ADIW R26,14
	CALL __GETW1P
	__PUTW1RNS 18,26
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	__GETD2Z 14
	MOVW R30,R26
	MOVW R22,R24
	CALL __LSRD16
	__PUTW1RNS 18,20
	CALL SUBOPT_0x6C
	__PUTD1RNS 18,22
	CALL SUBOPT_0x7
	ANDI R30,0xDF
	ST   X,R30
	CALL SUBOPT_0x47
	ADIW R30,4
	LDI  R26,LOW(1)
	STD  Z+0,R26
	CALL SUBOPT_0x47
	ST   -Y,R31
	ST   -Y,R30
	CALL _sync_G101
	MOV  R17,R30
_0x2020185:
_0x2020182:
_0x2020181:
	MOV  R30,R17
_0x20C0003:
	CALL __LOADLOCR4
	ADIW R28,10
	RET
_f_close:
	ST   -Y,R17
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	RCALL _f_sync
	MOV  R17,R30
	CPI  R17,0
	BRNE _0x2020186
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	CALL SUBOPT_0x5D
_0x2020186:
	MOV  R30,R17
	JMP  _0x20C0002
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif

	.CSEG
    .equ __lcd_direction=__lcd_port-1
    .equ __lcd_pin=__lcd_port-2
    .equ __lcd_rs=0
    .equ __lcd_rd=1
    .equ __lcd_enable=2
    .equ __lcd_busy_flag=7

	.DSEG

	.CSEG
__lcd_delay_G103:
    ldi   r31,15
__lcd_delay0:
    dec   r31
    brne  __lcd_delay0
	RET
__lcd_ready:
    in    r26,__lcd_direction
    andi  r26,0xf                 ;set as input
    out   __lcd_direction,r26
    sbi   __lcd_port,__lcd_rd     ;RD=1
    cbi   __lcd_port,__lcd_rs     ;RS=0
__lcd_busy:
	RCALL __lcd_delay_G103
    sbi   __lcd_port,__lcd_enable ;EN=1
	RCALL __lcd_delay_G103
    in    r26,__lcd_pin
    cbi   __lcd_port,__lcd_enable ;EN=0
	RCALL __lcd_delay_G103
    sbi   __lcd_port,__lcd_enable ;EN=1
	RCALL __lcd_delay_G103
    cbi   __lcd_port,__lcd_enable ;EN=0
    sbrc  r26,__lcd_busy_flag
    rjmp  __lcd_busy
	RET
__lcd_write_nibble_G103:
    andi  r26,0xf0
    or    r26,r27
    out   __lcd_port,r26          ;write
    sbi   __lcd_port,__lcd_enable ;EN=1
	CALL __lcd_delay_G103
    cbi   __lcd_port,__lcd_enable ;EN=0
	CALL __lcd_delay_G103
	RET
__lcd_write_data:
    cbi  __lcd_port,__lcd_rd 	  ;RD=0
    in    r26,__lcd_direction
    ori   r26,0xf0 | (1<<__lcd_rs) | (1<<__lcd_rd) | (1<<__lcd_enable) ;set as output
    out   __lcd_direction,r26
    in    r27,__lcd_port
    andi  r27,0xf
    ld    r26,y
	RCALL __lcd_write_nibble_G103
    ld    r26,y
    swap  r26
	RCALL __lcd_write_nibble_G103
    sbi   __lcd_port,__lcd_rd     ;RD=1
	JMP  _0x20C0001
__lcd_read_nibble_G103:
    sbi   __lcd_port,__lcd_enable ;EN=1
	CALL __lcd_delay_G103
    in    r30,__lcd_pin           ;read
    cbi   __lcd_port,__lcd_enable ;EN=0
	CALL __lcd_delay_G103
    andi  r30,0xf0
	RET
_lcd_read_byte0_G103:
	CALL __lcd_delay_G103
	RCALL __lcd_read_nibble_G103
    mov   r26,r30
	RCALL __lcd_read_nibble_G103
    cbi   __lcd_port,__lcd_rd     ;RD=0
    swap  r30
    or    r30,r26
	RET
_lcd_gotoxy:
	CALL __lcd_ready
	LD   R30,Y
	LDI  R31,0
	SUBI R30,LOW(-__base_y_G103)
	SBCI R31,HIGH(-__base_y_G103)
	LD   R30,Z
	LDD  R26,Y+1
	ADD  R30,R26
	ST   -Y,R30
	CALL __lcd_write_data
	LDD  R4,Y+1
	LDD  R9,Y+0
	ADIW R28,2
	RET
_lcd_clear:
	CALL __lcd_ready
	LDI  R30,LOW(2)
	ST   -Y,R30
	CALL __lcd_write_data
	CALL __lcd_ready
	LDI  R30,LOW(12)
	ST   -Y,R30
	CALL __lcd_write_data
	CALL __lcd_ready
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL __lcd_write_data
	LDI  R30,LOW(0)
	MOV  R9,R30
	MOV  R4,R30
	RET
_lcd_putchar:
    push r30
    push r31
    ld   r26,y
    set
    cpi  r26,10
    breq __lcd_putchar1
    clt
	CP   R4,R8
	BRLO _0x2060004
	__lcd_putchar1:
	INC  R9
	LDI  R30,LOW(0)
	ST   -Y,R30
	ST   -Y,R9
	RCALL _lcd_gotoxy
	brts __lcd_putchar0
_0x2060004:
	INC  R4
    rcall __lcd_ready
    sbi  __lcd_port,__lcd_rs ;RS=1
    ld   r26,y
    st   -y,r26
    rcall __lcd_write_data
__lcd_putchar0:
    pop  r31
    pop  r30
	JMP  _0x20C0001
_lcd_putsf:
	ST   -Y,R17
_0x2060008:
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ADIW R30,1
	STD  Y+1,R30
	STD  Y+1+1,R31
	SBIW R30,1
	LPM  R30,Z
	MOV  R17,R30
	CPI  R30,0
	BREQ _0x206000A
	ST   -Y,R17
	RCALL _lcd_putchar
	RJMP _0x2060008
_0x206000A:
_0x20C0002:
	LDD  R17,Y+0
	ADIW R28,3
	RET
__long_delay_G103:
    clr   r26
    clr   r27
__long_delay0:
    sbiw  r26,1         ;2 cycles
    brne  __long_delay0 ;2 cycles
	RET
__lcd_init_write_G103:
    cbi  __lcd_port,__lcd_rd 	  ;RD=0
    in    r26,__lcd_direction
    ori   r26,0xf7                ;set as output
    out   __lcd_direction,r26
    in    r27,__lcd_port
    andi  r27,0xf
    ld    r26,y
	CALL __lcd_write_nibble_G103
    sbi   __lcd_port,__lcd_rd     ;RD=1
	RJMP _0x20C0001
_lcd_init:
    cbi   __lcd_port,__lcd_enable ;EN=0
    cbi   __lcd_port,__lcd_rs     ;RS=0
	LDD  R8,Y+0
	LD   R30,Y
	SUBI R30,-LOW(128)
	__PUTB1MN __base_y_G103,2
	LD   R30,Y
	SUBI R30,-LOW(192)
	__PUTB1MN __base_y_G103,3
	CALL SUBOPT_0x8E
	CALL SUBOPT_0x8E
	CALL SUBOPT_0x8E
	RCALL __long_delay_G103
	LDI  R30,LOW(32)
	ST   -Y,R30
	RCALL __lcd_init_write_G103
	RCALL __long_delay_G103
	LDI  R30,LOW(40)
	CALL SUBOPT_0x8F
	LDI  R30,LOW(4)
	CALL SUBOPT_0x8F
	LDI  R30,LOW(133)
	CALL SUBOPT_0x8F
    in    r26,__lcd_direction
    andi  r26,0xf                 ;set as input
    out   __lcd_direction,r26
    sbi   __lcd_port,__lcd_rd     ;RD=1
	CALL _lcd_read_byte0_G103
	CPI  R30,LOW(0x5)
	BREQ _0x206000B
	LDI  R30,LOW(0)
	RJMP _0x20C0001
_0x206000B:
	CALL __lcd_ready
	LDI  R30,LOW(6)
	ST   -Y,R30
	CALL __lcd_write_data
	CALL _lcd_clear
	LDI  R30,LOW(1)
_0x20C0001:
	ADIW R28,1
	RET

	.CSEG

	.CSEG

	.DSEG
_prtc_get_time:
	.BYTE 0x2
_prtc_get_date:
	.BYTE 0x2
_buffer:
	.BYTE 0xF
_buffer2:
	.BYTE 0xA
_buffer3:
	.BYTE 0x5
_fat:
	.BYTE 0x232
_file:
	.BYTE 0x220
_path:
	.BYTE 0xB
_status_G100:
	.BYTE 0x1
_timer1_G100:
	.BYTE 0x1
_timer2_G100:
	.BYTE 0x1
_card_type_G100:
	.BYTE 0x1
_pv_S100000B000:
	.BYTE 0x1
_FatFs_G101:
	.BYTE 0x2
_Fsid_G101:
	.BYTE 0x2
_Drive_G101:
	.BYTE 0x1
_fatstr_S1010016000:
	.BYTE 0x4
__base_y_G103:
	.BYTE 0x4

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:11 WORDS
SUBOPT_0x0:
	ST   -Y,R31
	ST   -Y,R30
	JMP  _lcd_putsf

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:57 WORDS
SUBOPT_0x1:
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
	CALL _lcd_clear
	LDI  R30,LOW(_file)
	LDI  R31,HIGH(_file)
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x2:
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(6)
	LDI  R31,HIGH(6)
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x3:
	LDI  R31,0
	CALL __CWD1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x4:
	CALL __GETD1P
	CALL __PUTD1S0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 12 TIMES, CODE SIZE REDUCTION:19 WORDS
SUBOPT_0x5:
	__GETD1S 4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x6:
	CALL __GETD2S0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x7:
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	ADIW R26,4
	LD   R30,X
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x8:
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	LDD  R26,Z+1
	ST   -Y,R26
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	ADIW R30,50
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x9:
	__GETD1S 3
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0xA:
	CALL __PUTPARD1
	LDI  R30,LOW(1)
	ST   -Y,R30
	JMP  _disk_write

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0xB:
	__GETD2Z 34
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0xC:
	__GETD2S 1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0xD:
	ST   -Y,R31
	ST   -Y,R30
	RJMP SUBOPT_0x5

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0xE:
	__GETD1S 7
	CALL __PUTPARD1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0xF:
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _disk_read
	CPI  R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:13 WORDS
SUBOPT_0x10:
	ST   -Y,R31
	ST   -Y,R30
	__GETD1N 0x0
	CALL __PUTPARD1
	JMP  _move_window_G101

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x11:
	ADIW R26,46
	__GETD1N 0x0
	CALL __PUTDP1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0x12:
	ADIW R30,50
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(512)
	LDI  R31,HIGH(512)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _mem_set_G101

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x13:
	CALL __PUTDZ20
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ADIW R30,50
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x14:
	CALL __GETD1P
	MOVW R26,R0
	CALL __PUTDP1
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:17 WORDS
SUBOPT_0x15:
	__GETD2Z 18
	CALL __PUTPARD2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x16:
	LDI  R30,LOW(1)
	ST   -Y,R30
	JMP  _disk_write

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x17:
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 10 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x18:
	__GETD2S 8
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:27 WORDS
SUBOPT_0x19:
	__CPD2N 0x2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1A:
	__GETD1N 0x1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x1B:
	CALL __GETD1P
	__PUTD1S 4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1C:
	LD   R30,X
	LDI  R31,0
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:17 WORDS
SUBOPT_0x1D:
	LDD  R30,Y+12
	LDD  R31,Y+12+1
	ST   -Y,R31
	ST   -Y,R30
	MOVW R26,R18
	LDI  R30,LOW(512)
	LDI  R31,HIGH(512)
	CALL __DIVW21U
	__GETD2S 6
	CLR  R22
	CLR  R23
	CALL __ADDD12
	CALL __PUTPARD1
	CALL _move_window_G101
	CPI  R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1E:
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	ADIW R26,50
	MOVW R30,R18
	ANDI R31,HIGH(0x1FF)
	ADD  R26,R30
	ADC  R27,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 9 TIMES, CODE SIZE REDUCTION:13 WORDS
SUBOPT_0x1F:
	__GETD1S 8
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x20:
	LDD  R30,Y+12
	LDD  R31,Y+12+1
	ST   -Y,R31
	ST   -Y,R30
	__GETD2S 10
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x21:
	__GETD1N 0x100
	CALL __DIVD21U
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x22:
	__GETD2S 6
	CALL __ADDD12
	CALL __PUTPARD1
	CALL _move_window_G101
	CPI  R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x23:
	CALL __MULB1W2U
	ANDI R31,HIGH(0x1FF)
	LDD  R26,Y+12
	LDD  R27,Y+12+1
	ADIW R26,50
	ADD  R26,R30
	ADC  R27,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x24:
	CALL __GETW1P
	CLR  R22
	CLR  R23
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x25:
	__GETD1N 0x80
	CALL __DIVD21U
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x26:
	__GETD1N 0xFFFFFFFF
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x27:
	__GETD2S 14
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:16 WORDS
SUBOPT_0x28:
	LDD  R30,Y+18
	LDD  R31,Y+18+1
	ST   -Y,R31
	ST   -Y,R30
	MOVW R26,R16
	LDI  R30,LOW(512)
	LDI  R31,HIGH(512)
	CALL __DIVW21U
	RCALL SUBOPT_0x18
	CLR  R22
	CLR  R23
	CALL __ADDD12
	CALL __PUTPARD1
	CALL _move_window_G101
	MOV  R21,R30
	CPI  R21,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0x29:
	LDD  R26,Y+18
	LDD  R27,Y+18+1
	ADIW R26,50
	MOVW R30,R16
	ANDI R31,HIGH(0x1FF)
	ADD  R30,R26
	ADC  R31,R27
	MOVW R18,R30
	__GETD1S 14
	ANDI R30,LOW(0x1)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x2A:
	__GETD2S 10
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x2B:
	LDD  R30,Y+18
	LDD  R31,Y+18+1
	ST   -Y,R31
	ST   -Y,R30
	__GETD2S 16
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x2C:
	RCALL SUBOPT_0x18
	CALL __ADDD12
	CALL __PUTPARD1
	CALL _move_window_G101
	MOV  R21,R30
	CPI  R21,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x2D:
	CALL __MULB1W2U
	ANDI R31,HIGH(0x1FF)
	LDD  R26,Y+18
	LDD  R27,Y+18+1
	ADIW R26,50
	ADD  R30,R26
	ADC  R31,R27
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x2E:
	__GETD2S 5
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x2F:
	LDD  R26,Y+9
	LDD  R27,Y+9+1
	ADIW R26,30
	CALL __GETD1P
	RCALL SUBOPT_0x2E
	CALL __CPD21
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x30:
	LDD  R30,Y+9
	LDD  R31,Y+9+1
	ST   -Y,R31
	ST   -Y,R30
	RJMP SUBOPT_0xE

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:17 WORDS
SUBOPT_0x31:
	__CPD2N 0x1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 9 TIMES, CODE SIZE REDUCTION:37 WORDS
SUBOPT_0x32:
	__CPD2N 0xFFFFFFFF
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 10 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x33:
	__GETD1N 0x0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x34:
	CALL __PUTPARD1
	JMP  _put_fat_G101

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x35:
	__GETD2Z 14
	RJMP SUBOPT_0x32

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x36:
	ADIW R26,14
	CALL __GETD1P_INC
	__SUBD1N -1
	CALL __PUTDP1_DEC
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x37:
	__GETD1S 16
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x38:
	CALL __GETD1S0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x39:
	__PUTD1S 4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x3A:
	LDD  R30,Y+20
	LDD  R31,Y+20+1
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x3B:
	__GETD1S 18
	CALL __PUTPARD1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x3C:
	CALL _get_fat_G101
	__PUTD1S 12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x3D:
	__GETD2S 12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 11 TIMES, CODE SIZE REDUCTION:17 WORDS
SUBOPT_0x3E:
	__GETD1S 12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x3F:
	__PUTD1S 8
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x40:
	RCALL SUBOPT_0x5
	RCALL SUBOPT_0x18
	CALL __CPD12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x41:
	__GETD1S 10
	CALL __PUTPARD1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x42:
	RCALL SUBOPT_0x3E
	CALL __CPD10
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x43:
	CALL __SWAPD12
	CALL __SUBD12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 10 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x44:
	LD   R30,X
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x45:
	CALL __GETD1P
	__PUTD1S 2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:11 WORDS
SUBOPT_0x46:
	__GETD2S 2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 24 TIMES, CODE SIZE REDUCTION:43 WORDS
SUBOPT_0x47:
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	CALL __GETW1P
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x48:
	ADIW R30,30
	MOVW R26,R30
	CALL __GETD1P
	RCALL SUBOPT_0x46
	CALL __CPD21
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x49:
	__GETD1S 2
	CALL __CPD10
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x4A:
	__GETD1S 2
	__PUTD1SNS 8,10
	RJMP SUBOPT_0x47

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x4B:
	CALL _get_fat_G101
	__PUTD1S 2
	RJMP SUBOPT_0x46

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x4C:
	CALL __PUTPARD1
	JMP  _clust2sect_G101

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x4D:
	CLR  R22
	CLR  R23
	CALL __ADDD12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x4E:
	ANDI R30,LOW(0xF)
	ANDI R31,HIGH(0xF)
	LSL  R30
	CALL __LSLW4
	ADD  R30,R26
	ADC  R31,R27
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x4F:
	CALL __GETD1P
	CALL __CPD10
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x50:
	LDD  R26,Y+7
	LDD  R27,Y+7+1
	CALL __GETW1P
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x51:
	__GETD2Z 10
	CALL __PUTPARD2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x52:
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x53:
	CALL __SAVELOCR4
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	ST   -Y,R31
	ST   -Y,R30
	RJMP SUBOPT_0x17

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:29 WORDS
SUBOPT_0x54:
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	__GETD2Z 14
	CALL __PUTPARD2
	CALL _move_window_G101
	MOV  R17,R30
	CPI  R17,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x55:
	ST   -Y,R19
	ST   -Y,R18
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	LDD  R26,Z+20
	LDD  R27,Z+21
	ST   -Y,R27
	ST   -Y,R26
	LDI  R30,LOW(11)
	LDI  R31,HIGH(11)
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x56:
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x57:
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	ADIW R30,1
	STD  Y+10,R30
	STD  Y+10+1,R31
	SBIW R30,1
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADD  R26,R30
	ADC  R27,R31
	LD   R16,X
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:11 WORDS
SUBOPT_0x58:
	LDD  R30,Y+8
	LDD  R31,Y+8+1
	ADIW R30,1
	STD  Y+8,R30
	STD  Y+8+1,R31
	SBIW R30,1
	ADD  R30,R20
	ADC  R31,R21
	ST   Z,R16
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x59:
	ADD  R30,R26
	ADC  R31,R27
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	ST   X+,R30
	ST   X,R31
	CPI  R16,32
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x5A:
	RCALL SUBOPT_0x33
	CALL __PUTDP1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x5B:
	__PUTD1SNS 6,6
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x5C:
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x5D:
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   X+,R30
	ST   X,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x5E:
	MOVW R26,R18
	ADIW R26,20
	RJMP SUBOPT_0x24

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x5F:
	MOVW R26,R18
	ADIW R26,26
	CALL __GETW1P
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x60:
	CLR  R22
	CLR  R23
	CALL __ORD12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x61:
	CALL __PUTPARD1
	RJMP SUBOPT_0xF

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x62:
	ADIW R30,50
	SUBI R30,LOW(-510)
	SBCI R31,HIGH(-510)
	MOVW R26,R30
	CALL __GETW1P
	CPI  R30,LOW(0xAA55)
	LDI  R26,HIGH(0xAA55)
	CPC  R31,R26
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0x63:
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(_fatstr_S1010016000)
	LDI  R31,HIGH(_fatstr_S1010016000)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(3)
	LDI  R31,HIGH(3)
	ST   -Y,R31
	ST   -Y,R30
	CALL _mem_cmp_G101
	SBIW R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x64:
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	LDD  R26,Z+1
	ST   -Y,R26
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x65:
	__PUTD1S 18
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x66:
	__GETD1S 18
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x67:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	SUBI R26,LOW(-64)
	SBCI R27,HIGH(-64)
	CALL __GETW1P
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x68:
	__GETD2S 22
	RJMP SUBOPT_0x4D

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x69:
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	LDD  R26,Z+7
	LDD  R27,Z+8
	MOVW R30,R26
	CALL __LSRW4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x6A:
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	RCALL SUBOPT_0xB
	RCALL SUBOPT_0x66
	CALL __ADDD12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x6B:
	LDD  R30,Y+4
	LDI  R26,LOW(_FatFs_G101)
	LDI  R27,HIGH(_FatFs_G101)
	LDI  R31,0
	LSL  R30
	ROL  R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x6C:
	CALL _get_fattime
	RCALL SUBOPT_0x39
	RJMP SUBOPT_0x5

;OPTIMIZER ADDED SUBROUTINE, CALLED 9 TIMES, CODE SIZE REDUCTION:13 WORDS
SUBOPT_0x6D:
	LDD  R26,Y+26
	LDD  R27,Y+26+1
	CALL __GETW1P
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x6E:
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+28
	LDD  R31,Y+28+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x6F:
	LDD  R26,Z+2
	LDD  R27,Z+3
	ST   -Y,R27
	ST   -Y,R26
	CALL _validate_G101
	MOV  R17,R30
	CPI  R17,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x70:
	LDD  R30,Y+26
	LDD  R31,Y+26+1
	__GETD2Z 6
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:17 WORDS
SUBOPT_0x71:
	LDD  R26,Y+26
	LDD  R27,Y+26+1
	ADIW R26,4
	LD   R30,X
	ORI  R30,0x80
	ST   X,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x72:
	__PUTD1S 12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x73:
	LDD  R26,Y+26
	LDD  R27,Y+26+1
	ADIW R26,5
	RJMP SUBOPT_0x44

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x74:
	LDI  R30,LOW(512)
	LDI  R31,HIGH(512)
	CALL __DIVW21U
	MOVW R20,R30
	MOV  R0,R20
	OR   R0,R21
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x75:
	LDD  R30,Z+2
	MOVW R26,R0
	LDI  R31,0
	CP   R30,R26
	CPC  R31,R27
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x76:
	LDD  R30,Z+1
	ST   -Y,R30
	LDD  R30,Y+7
	LDD  R31,Y+7+1
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x77:
	LDD  R30,Y+26
	LDD  R31,Y+26+1
	__GETD2Z 22
	RJMP SUBOPT_0x3E

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x78:
	CALL __SUBD21
	MOVW R30,R20
	CLR  R22
	CLR  R23
	CALL __CPD21
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x79:
	CALL __SUBD21
	__GETD1N 0x200
	CALL __MULD12U
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x7A:
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(512)
	LDI  R31,HIGH(512)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _mem_cpy_G101

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x7B:
	ADIW R26,5
	LD   R30,X
	ADD  R30,R20
	ST   X,R30
	MOVW R30,R20
	LSL  R30
	ROL  R31
	MOV  R31,R30
	LDI  R30,0
	MOVW R18,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x7C:
	LDD  R30,Z+1
	ST   -Y,R30
	LDD  R30,Y+27
	LDD  R31,Y+27+1
	ADIW R30,32
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x7D:
	__GETD2Z 22
	CALL __PUTPARD2
	RJMP SUBOPT_0x16

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x7E:
	ADIW R26,4
	LD   R30,X
	ANDI R30,0xBF
	ST   X,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x7F:
	MOVW R30,R26
	MOVW R22,R24
	__ANDD1N 0x1FF
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x80:
	__GETD2N 0x200
	RJMP SUBOPT_0x43

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:7 WORDS
SUBOPT_0x81:
	__GETD2Z 6
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x82:
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R19
	ST   -Y,R18
	JMP  _mem_cpy_G101

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x83:
	MOVW R30,R18
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	ADD  R30,R26
	ADC  R31,R27
	STD  Y+6,R30
	STD  Y+6+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x84:
	ADIW R30,6
	MOVW R0,R30
	MOVW R26,R30
	CALL __GETD1P
	MOVW R26,R30
	MOVW R24,R22
	MOVW R30,R18
	RJMP SUBOPT_0x4D

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x85:
	LD   R30,X+
	LD   R31,X+
	ADD  R30,R18
	ADC  R31,R19
	ST   -X,R31
	ST   -X,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 10 TIMES, CODE SIZE REDUCTION:15 WORDS
SUBOPT_0x86:
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	CALL __GETW1P
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x87:
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+24
	LDD  R31,Y+24+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x88:
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	ADIW R26,10
	CALL __GETD1P
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x89:
	LDD  R30,Y+22
	LDD  R31,Y+22+1
	RJMP SUBOPT_0x81

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:17 WORDS
SUBOPT_0x8A:
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	ADIW R26,4
	LD   R30,X
	ORI  R30,0x80
	ST   X,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x8B:
	LDD  R30,Z+1
	ST   -Y,R30
	LDD  R30,Y+23
	LDD  R31,Y+23+1
	ADIW R30,32
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x8C:
	LDD  R26,Y+22
	LDD  R27,Y+22+1
	ADIW R26,5
	RJMP SUBOPT_0x44

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x8D:
	LDD  R30,Y+22
	LDD  R31,Y+22+1
	__GETD2Z 22
	RJMP SUBOPT_0x1F

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x8E:
	CALL __long_delay_G103
	LDI  R30,LOW(48)
	ST   -Y,R30
	JMP  __lcd_init_write_G103

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x8F:
	ST   -Y,R30
	CALL __lcd_write_data
	JMP  __long_delay_G103


	.CSEG
_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x7D0
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__ADDD12:
	ADD  R30,R26
	ADC  R31,R27
	ADC  R22,R24
	ADC  R23,R25
	RET

__SUBD12:
	SUB  R30,R26
	SBC  R31,R27
	SBC  R22,R24
	SBC  R23,R25
	RET

__SUBD21:
	SUB  R26,R30
	SBC  R27,R31
	SBC  R24,R22
	SBC  R25,R23
	RET

__ORD12:
	OR   R30,R26
	OR   R31,R27
	OR   R22,R24
	OR   R23,R25
	RET

__LSLD12:
	TST  R30
	MOV  R0,R30
	MOVW R30,R26
	MOVW R22,R24
	BREQ __LSLD12R
__LSLD12L:
	LSL  R30
	ROL  R31
	ROL  R22
	ROL  R23
	DEC  R0
	BRNE __LSLD12L
__LSLD12R:
	RET

__LSRD12:
	TST  R30
	MOV  R0,R30
	MOVW R30,R26
	MOVW R22,R24
	BREQ __LSRD12R
__LSRD12L:
	LSR  R23
	ROR  R22
	ROR  R31
	ROR  R30
	DEC  R0
	BRNE __LSRD12L
__LSRD12R:
	RET

__LSLW4:
	LSL  R30
	ROL  R31
__LSLW3:
	LSL  R30
	ROL  R31
__LSLW2:
	LSL  R30
	ROL  R31
	LSL  R30
	ROL  R31
	RET

__LSRW4:
	LSR  R31
	ROR  R30
__LSRW3:
	LSR  R31
	ROR  R30
__LSRW2:
	LSR  R31
	ROR  R30
	LSR  R31
	ROR  R30
	RET

__LSLD1:
	LSL  R30
	ROL  R31
	ROL  R22
	ROL  R23
	RET

__LSRD16:
	MOV  R30,R22
	MOV  R31,R23
	LDI  R22,0
	LDI  R23,0
	RET

__LSLD16:
	MOV  R22,R30
	MOV  R23,R31
	LDI  R30,0
	LDI  R31,0
	RET

__CWD1:
	MOV  R22,R31
	ADD  R22,R22
	SBC  R22,R22
	MOV  R23,R22
	RET

__MULD12U:
	MUL  R23,R26
	MOV  R23,R0
	MUL  R22,R27
	ADD  R23,R0
	MUL  R31,R24
	ADD  R23,R0
	MUL  R30,R25
	ADD  R23,R0
	MUL  R22,R26
	MOV  R22,R0
	ADD  R23,R1
	MUL  R31,R27
	ADD  R22,R0
	ADC  R23,R1
	MUL  R30,R24
	ADD  R22,R0
	ADC  R23,R1
	CLR  R24
	MUL  R31,R26
	MOV  R31,R0
	ADD  R22,R1
	ADC  R23,R24
	MUL  R30,R27
	ADD  R31,R0
	ADC  R22,R1
	ADC  R23,R24
	MUL  R30,R26
	MOV  R30,R0
	ADD  R31,R1
	ADC  R22,R24
	ADC  R23,R24
	RET

__MULB1W2U:
	MOV  R22,R30
	MUL  R22,R26
	MOVW R30,R0
	MUL  R22,R27
	ADD  R31,R0
	RET

__DIVW21U:
	CLR  R0
	CLR  R1
	LDI  R25,16
__DIVW21U1:
	LSL  R26
	ROL  R27
	ROL  R0
	ROL  R1
	SUB  R0,R30
	SBC  R1,R31
	BRCC __DIVW21U2
	ADD  R0,R30
	ADC  R1,R31
	RJMP __DIVW21U3
__DIVW21U2:
	SBR  R26,1
__DIVW21U3:
	DEC  R25
	BRNE __DIVW21U1
	MOVW R30,R26
	MOVW R26,R0
	RET

__DIVD21U:
	PUSH R19
	PUSH R20
	PUSH R21
	CLR  R0
	CLR  R1
	CLR  R20
	CLR  R21
	LDI  R19,32
__DIVD21U1:
	LSL  R26
	ROL  R27
	ROL  R24
	ROL  R25
	ROL  R0
	ROL  R1
	ROL  R20
	ROL  R21
	SUB  R0,R30
	SBC  R1,R31
	SBC  R20,R22
	SBC  R21,R23
	BRCC __DIVD21U2
	ADD  R0,R30
	ADC  R1,R31
	ADC  R20,R22
	ADC  R21,R23
	RJMP __DIVD21U3
__DIVD21U2:
	SBR  R26,1
__DIVD21U3:
	DEC  R19
	BRNE __DIVD21U1
	MOVW R30,R26
	MOVW R22,R24
	MOVW R26,R0
	MOVW R24,R20
	POP  R21
	POP  R20
	POP  R19
	RET

__GETW1P:
	LD   R30,X+
	LD   R31,X
	SBIW R26,1
	RET

__GETD1P:
	LD   R30,X+
	LD   R31,X+
	LD   R22,X+
	LD   R23,X
	SBIW R26,3
	RET

__GETD1P_INC:
	LD   R30,X+
	LD   R31,X+
	LD   R22,X+
	LD   R23,X+
	RET

__PUTDP1:
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	RET

__PUTDP1_DEC:
	ST   -X,R23
	ST   -X,R22
	ST   -X,R31
	ST   -X,R30
	RET

__GETD1S0:
	LD   R30,Y
	LDD  R31,Y+1
	LDD  R22,Y+2
	LDD  R23,Y+3
	RET

__GETD2S0:
	LD   R26,Y
	LDD  R27,Y+1
	LDD  R24,Y+2
	LDD  R25,Y+3
	RET

__PUTD1S0:
	ST   Y,R30
	STD  Y+1,R31
	STD  Y+2,R22
	STD  Y+3,R23
	RET

__PUTDZ20:
	ST   Z,R26
	STD  Z+1,R27
	STD  Z+2,R24
	STD  Z+3,R25
	RET

__PUTPARD1:
	ST   -Y,R23
	ST   -Y,R22
	ST   -Y,R31
	ST   -Y,R30
	RET

__PUTPARD2:
	ST   -Y,R25
	ST   -Y,R24
	ST   -Y,R27
	ST   -Y,R26
	RET

__SWAPD12:
	MOV  R1,R24
	MOV  R24,R22
	MOV  R22,R1
	MOV  R1,R25
	MOV  R25,R23
	MOV  R23,R1

__SWAPW12:
	MOV  R1,R27
	MOV  R27,R31
	MOV  R31,R1

__SWAPB12:
	MOV  R1,R26
	MOV  R26,R30
	MOV  R30,R1
	RET

__CPD10:
	SBIW R30,0
	SBCI R22,0
	SBCI R23,0
	RET

__CPD02:
	CLR  R0
	CP   R0,R26
	CPC  R0,R27
	CPC  R0,R24
	CPC  R0,R25
	RET

__CPD12:
	CP   R30,R26
	CPC  R31,R27
	CPC  R22,R24
	CPC  R23,R25
	RET

__CPD21:
	CP   R26,R30
	CPC  R27,R31
	CPC  R24,R22
	CPC  R25,R23
	RET

__SAVELOCR6:
	ST   -Y,R21
__SAVELOCR5:
	ST   -Y,R20
__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR6:
	LDD  R21,Y+5
__LOADLOCR5:
	LDD  R20,Y+4
__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

;END OF CODE MARKER
__END_OF_CODE:
