#include <mega64.h>

#include <ff.h>

#include <stdio.h>

#include <delay.h>


#asm
   .equ __lcd_port=0x15 ;PORTC
#endasm
#include <lcd.h>


#define T1_OVF_FREQ 100
#define T1_PRESC 1024L
#define T1_INIT (0x10000L-(_MCU_CLOCK_FREQUENCY_/(T1_PRESC*T1_OVF_FREQ)))

unsigned char buffer[15]="ECA the BEST..";
unsigned char buffer2[10];
unsigned char buffer3[5];



FRESULT res;
unsigned int nbytes;
FATFS fat;
FIL file;
char path[]="0:/ECA.txt";




interrupt [TIM1_OVF] void timer_comp_isr(void)
{
/* re-initialize Timer1 */
TCNT1H=T1_INIT>>8;
TCNT1L=T1_INIT&0xFF;
/* card access low level timing function */
disk_timerproc();
}




void main(void)
{



TCCR1A=0x00;
TCCR1B=(1<<CS12)|(1<<CS10);
TCNT1H=T1_INIT>>8;
TCNT1L=T1_INIT&0xFF;
TIMSK=1<<TOIE1;




#asm("sei")

lcd_init(16);
lcd_clear();




if ((res=f_mount(0,&fat))==FR_OK)
    lcd_putsf("FAT mounted = OK");   
    

delay_ms(1000);
lcd_clear();
if ((res=f_open(&file,path,FA_CREATE_ALWAYS))==FR_OK)
    lcd_putsf("File opened");  
    
                              
delay_ms(1000);                                  
lcd_clear();
if ((res=f_write(&file,buffer,15,&nbytes))==FR_OK)
    lcd_putsf("Writing Data"); 
    
    
                                
delay_ms(1000);                                  
lcd_clear();    
if ((res=f_close(&file))==FR_OK)
   lcd_putsf("File closed");   
                              
   
delay_ms(1000);
lcd_clear();
if ((res=f_open(&file,path,FA_READ))==FR_OK)
    lcd_putsf("File opened"); 
                    
                      
delay_ms(1000);
lcd_clear();    
if ((res=f_read(&file,buffer2,10,&nbytes))==FR_OK)
    lcd_putsf("Reading Data");   
                      
    
delay_ms(1000);
lcd_clear();    
if ((res=f_read(&file,buffer3,5,&nbytes))==FR_OK)
    lcd_putsf("Reading Data");   
    
    
delay_ms(1000);                                  
lcd_clear();    
if ((res=f_close(&file))==FR_OK)
   lcd_putsf("File closed"); 


while(1);
 }




